#include "engine.h"

#include "anim.h"
#include "error.h"
#include "misc.h"
#include "gfx.h"
#include "tile.h"


void Anim::DrawFrame( FRAME *f, int shade, int flags )
{
	overwritesprite(origin.x + f->x, origin.y + f->y,
		(short)f->id,
		(schar)ClipRange(f->shade + shade, -128, 127),
		(char)(flags | kOrientMiddle), //f->flags |
		(char)f->pal);

//	rotatesprite(
//		origin.x + f->x << 16,
//		origin.y + f->y << 16,
//		0x10000,					// NOTE: change to f->zoom after converting QAVs
//		(short)((flags & 8) << 7),	// NOTE: change to f->angle after converting QAVs
//		(short)f->id,
//		(schar)ClipRange(f->shade + shade, -128, 127),
//		(char)f->pal,
//		(char)(((flags&1^1)<<4)+(stat&2)+((stat&4)>>2)+((stat&16)>>2)^((stat&8)>>1)),
//		windowx1,windowy1,windowx2,windowy2);
}


// render a complete frame for time t1
void Anim::Play( ulong /* t0 */, ulong t1, int shade, int flags, PLAY_PROC callback )
{
	int i;

	for (i = 0; i < frames; i++)
	{
		if ( frame[i].timeStart <= t1 && frame[i].timeStop > t1 )
		{
			switch ( frame[i].type )
			{
				case kQFrameTile:
					DrawFrame(&frame[i], shade, flags);
					break;

				case kQFrameSound:
					// Play the sound. Hey! How does everyone else hear this?
					break;

				case kQFrameTrigger:
					if (callback != NULL)
						callback( &frame[i] );
					break;

				default:
					ThrowError("Invalid frame type in QAV file", ES_ERROR);
					return;	// code should not reach return
			}
		}
	}
}


void Anim::Preload( void )
{
	for (int i = 0; i < frames; i++)
		tilePreloadTile(frame[i].id);
}
