#ifndef __ANIM_H
#define __ANIM_H

#include "helix.h"
#include "typedefs.h"
#include "stdlib.h"


enum
{
	kQFrameTile		= 0L,
	kQFrameSound,
	kQFrameTrigger,
};


enum
{
	// begin rotatesprite compatible flags
	kQFrameNormal			= 0,		// no flags
	kQFrameTranslucent		= 0x01,		// frame is translucent
	kQFrameScale			= 0x02,		// frame is scaled to viewing window
	kQFrameYFlip			= 0x04,		// frame is y-flipped
	kQFrameUnclipped		= 0x08,		// frame is not clipped to umost/dmost
	kQFrameStatus			= 0x0A,		// frame is not masked (used for status bar)
	kQFrameCorner			= 0x10,		// frame is positioned by top left corner instead of origin
	kQFrameTranslucentR		= 0x20,		// frame is translucent, using reverse translucency table
	kQFrameNoMask			= 0x40,
	kQFrameAllPages			= 0x80,

	// begin internal flags
	kQFrameXFlip			= 0x100,	// frame is x-flipped
};


struct FRAME
{
	long			timeStart;
	long			timeStop;
	int				type;
	int				id;
	int				flags;
	union
	{
		// type = kQFrameTile
		struct
		{
			int		x, y;
			int		layer;
			int		shade;
			int		pal;
//			long	zoom;	// zoom in 16:16 fixed format
//			short	angle;	// angle in Build units (0 is straight up)
		};

		// type = kQFrameSound
		struct
		{
			int		priority;
			int		volume;
			int		soundID;
		};

		// type = kQFrameTrigger
		struct {
			int		trigger;
		};
	};
};


typedef void (*PLAY_PROC)( FRAME * pFrame );


struct Anim
{
	char 	signature[4];
	short 	version;
	char	dummy[2];

	int		frames;
	long	duration;
	int		backTile;
	POINT	origin;
	FRAME	frame[1];

	void	DrawFrame( FRAME *, int shade, int flags );
	void	Draw( ulong t, int shade, int flags );
	void	Play( ulong t0, ulong t1, PLAY_PROC callback = NULL );
	void	Preload( void );
};

#endif
