#include "engine.h"

#include "anim.h"
#include "error.h"
#include "misc.h"
#include "gfx.h"
#include "tile.h"
#include "trig.h"


void Anim::DrawFrame( FRAME *f, int shade, int flags )
{
	short nAngle = 0;
	flags |= f->flags;

	if ( flags & kQFrameXFlip )
	{
		nAngle = kAngle180;
		flags &= kQFrameXFlip;
		flags ^= kQFrameYFlip;
	}

	rotatesprite(
		origin.x + f->x << 16,
		origin.y + f->y << 16,
		0x10000,					// NOTE: change to f->zoom after converting QAVs
		nAngle,						// NOTE: change to f->angle after converting QAVs
		(short)f->id,
		(schar)ClipRange(f->shade + shade, -128, 127),
		(char)f->pal,
		(char)flags,
		windowx1, windowy1, windowx2, windowy2);
}


// render a complete frame for time t
void Anim::Draw( ulong t, int shade, int flags )
{
	int i;

	for (i = 0; i < frames; i++)
	{
		if ( frame[i].timeStart <= t && frame[i].timeStop > t )
		{
			switch ( frame[i].type )
			{
				case kQFrameTile:
					DrawFrame(&frame[i], shade, flags);
					break;

				case kQFrameSound:
				case kQFrameTrigger:
					break;

				default:
					ThrowError("Invalid frame type in QAV file", ES_ERROR);
					return;	// code should not reach return
			}
		}
	}
}


// play a complete frame for time interval t0-t1
void Anim::Play( ulong t0, ulong t1, PLAY_PROC callback )
{
	int i;

	for (i = 0; i < frames; i++)
	{
		if ( frame[i].timeStart <= t1 && frame[i].timeStop > t0 )
		{
			switch ( frame[i].type )
			{
				case kQFrameTile:
					break;

				case kQFrameSound:
					// Play the sound. Hey! How does everyone else hear this?
					break;

				case kQFrameTrigger:
					if (callback != NULL)
						callback( &frame[i] );
					break;

				default:
					ThrowError("Invalid frame type in QAV file", ES_ERROR);
					return;	// code should not reach return
			}
		}
	}
}


void Anim::Preload( void )
{
	for (int i = 0; i < frames; i++)
		tilePreloadTile(frame[i].id);
}
