#include "engine.h"

#include "qav.h"
#include "error.h"
#include "misc.h"
#include "tile.h"
#include "trig.h"
#include "debug4g.h"


static void DrawFrame( int x, int y, TILE_FRAME *f, int shade, int flags )
{
	short nAngle = 0;
	flags |= f->flags;

	if ( flags & kQFrameXFlip )
	{
		nAngle = kAngle180;
		flags &= kQFrameXFlip;
		flags ^= kQFrameYFlip;
	}

	rotatesprite(
		x + f->x << 16,
		y + f->y << 16,
		f->zoom,
		f->angle,
		(short)f->id,
		(schar)ClipRange(f->shade + shade, -128, 127),
		(char)f->pal,
		(char)flags,
		windowx1, windowy1, windowx2, windowy2);
}


// render a complete frame for time t
void QAV::Draw( ulong t, int shade, int flags )
{
	dassert(ticksPerFrame > 0);
	FRAME *f = &frame[t / ticksPerFrame];
	for (int i = 0; i < kMaxLayers; i++)
	{
		if ( f->layer[i].id >= 0 )
		 	DrawFrame(origin.x, origin.y, &f->layer[i], shade, flags);
	}
}


// play a frame for time interval t0-t1
void QAV::Play( ulong t0, ulong t1, PLAY_PROC callback )
{
	dassert(ticksPerFrame > 0);
	FRAME *f = &frame[t0 / ticksPerFrame];
	while ( t0 < t1 )
	{
		// Play the sound
		// .
		// .
		// .

		// Callback triggers
		if ( f->trigger.id >= 0 && callback != NULL )
			callback( f->trigger.id );

		t0 += ticksPerFrame;
		f++;
	}
}


void QAV::Preload( void )
{
	for (int i = 0; i < nFrames; i++)
	{
		for (int j = 0; j < kMaxLayers; j++)
		{
			if ( frame[i].layer[j].id >= 0 )
				tilePreloadTile(frame[i].layer[j].id);
		}
	}
}
