#ifndef __SCREEN_H
#define __SCREEN_H

#include "typedefs.h"


/***********************************************************************
 * Constants
 **********************************************************************/
enum {
	kPLUNormal 		= 0,
	kPLURed			= 2,
	kPLUCultist2	= 3,
	kPLUSpider3		= 4,
	kPLUGray		= 5,
	kPLUGrayish		= 6,
	kPLUSpider1		= 7,
	kPLUSpider2		= 8,
	kPLUFlame		= 9,
	kPLUCold		= 10,
	kPLUPlayer1		= 11,
	kPLUPlayer2,
	kPLUPlayer3,
	kPLUPlayer4,
	kPLUPlayer5,
	kPLUPlayer6,
	kPLUPlayer7,
	kPLUPlayer8,
	kMaxPLU,
};

enum {
	kPalNormal		= 0,
	kPalWater,
	kPalBeast,
	kMaxPalettes,
};

#define kPalLookups 64


extern int gGammaLevels;
extern BYTE gStdColor[32];


/***********************************************************************
 * Functions
 **********************************************************************/
void scrInit(void);
void scrSetPalette(int nPal);
void scrSetGamma( int nGamma );
void scrDacEffect(int r, int g, int b);
void scrClearDacEffect( void );
void scrSetDac( ulong nTicks );
void scrSetMessage( char * );
void scrDisplayMessage( int nColor );
void scrLoadPalette( void );
void scrSetGameMode( void );
void scrNextPage( void );
BYTE scrFindClosestColor( int r, int g, int b );
void scrCreateStdColors( void );

#endif


