#include <fcntl.h>
#include <io.h>
#include <sys\stat.h>

#include "engine.h"
#include "options.h"
#include "debug4g.h"
#include "key.h"
#include "resource.h"
#include "globals.h"
#include "helix.h"
#include "error.h"
#include "gfx.h"

#include <memcheck.h>

/*
struct {
	char *text;
	int  vMode;
	int  xRes;
	int  yRes;
} gVideoModes[] =
{
	{ "VGA   320 x 200",  1, 320,   200 },
	{ "VESA  640 x 480",  1, 640,   480 },
	{ "VESA  800 x 600",  1, 800,   600 },
	{ "VESA 1024 x 768",  1, 1024,  768 },
	{ "VESA 1280 x 1024", 1, 1280, 1024 },

	{ "320 x 200 (Mode X)", 0, 320, 200 },
	{ "256 x 200 (Mode X)", 0, 256, 200 },
	{ "360 x 270 (Mode X)", 0, 320, 200 },

	{ "320 x 200 for TSENG 4000 chipset",        2, 320, 200 },
	{ "320 x 200 for Paradise WD90Cxx chipset",  3, 320, 200 },
	{ "320 x 200 for S3 chipset",                4, 320, 200 },
	{ "Crystal Eyes (tm) 320 x 200 (STEREO)",    5, 320, 200 },
	{ "Red-Blue glasses  320 x 200 (STEREO)",    6, 320, 200 }
b };

static long chainxres[4] = {256,320,360,400};
static long chainyres[11] = {200,240,256,270,300,350,
										360,400,480,512,540};
static long vesares[7][2] = {320,200,640,400,640,480,
										800,600,1024,768,
										1280,1024,1600,1200};
*/

BOOL gFallingDamage		= TRUE;
BOOL gViewBobbing		= TRUE;
BOOL gRunBackwards		= FALSE;
BOOL gFriendlyFire		= TRUE;
BOOL gRespawnItems		= FALSE;
BOOL gRespawnEnemies	= FALSE;
BOOL gOverlayMap		= FALSE;
BOOL gRotateMap			= FALSE;
BOOL gGraphNumbers		= FALSE;
BOOL gAutoAim			= TRUE;
BOOL gInfiniteAmmo		= FALSE;
BOOL gFullMap			= FALSE;
BOOL gClipEnabled		= TRUE;
BOOL gShowDetails       = TRUE;

extern "C" void initgroupfile(char *);


/*******************************************************************************
	FUNCTION:		InitEngine()

	DESCRIPTION:

	PARAMETERS:

	RETURNS:

	NOTES:
		; 0 = Unchained mode
		; 1 = VESA 2.0 linear buffer
		; 2 = Buffered Screen/VESA mode
		; 3 = TSENG mode
		; 4 = Paradise mode
		; 5 = S3
		; 6 = Crystal Eyes mode
		; 7 = Red-Blue mode
*******************************************************************************/
void InitEngine(void)
{
//	initgroupfile("");

	atexit(uninitengine);	// restores key interrupt on crash

	int mode = BloodINI.GetKeyInt("Video", "Mode", 2);
	int xRes = BloodINI.GetKeyInt("Video", "XRes", 320);
	int yRes = BloodINI.GetKeyInt("Video", "YRes", 200);

	if (mode >= 3 && mode <= 7)
	{
		if (xRes != 320 || yRes != 200)
			ThrowError("You wanker!  This video mode doesn't support that resolution.", ES_ERROR);
	}

	initengine(mode, xRes, yRes);

	switch (mode)
	{
		case 0:	//	non-chained
			if (chainnumpages > 1)
			{
				if (!gFindMode(320, 240, 256, NONCHAIN256))
					ThrowError("Helix driver not found", ES_ERROR);
				gPageTable[0].bytesPerRow = xdim / 4;
				gPageTable[0].size = chainsiz;
			}
			else	// memory buffered
			{
				if (!gFindMode(320, 200, 256, CHAIN256))
					ThrowError("Helix driver not found", ES_ERROR);
				gPageTable[0].begin = (unsigned)frameplace;
				gPageTable[0].bytesPerRow = xdim;
				gPageTable[0].size = xdim * ydim;
			}
			break;

		default:
			// generic linear frame buffer
			if (!gFindMode(320, 200, 256, CHAIN256))
				ThrowError("Helix driver not found", ES_ERROR);
			gPageTable[0].begin = (unsigned)frameplace;
			gPageTable[0].bytesPerRow = xdim;
			gPageTable[0].size = xdim * ydim;
	}

	gfxSetClip(0, 0, xRes, yRes);
}
