#ifndef __EVENTQ_H
#define __EVENTQ_H

#include <stdlib.h>
#include "typedefs.h"

// command types
enum {
	kCommandOff			= 0,
	kCommandOn			= 1,
	kCommandState		= 2,
	kCommandToggle		= 3,
	kCommandNotState	= 4,
	kCommandLink		= 5,
	kCommandCallback	= 6,
	kCommandRespawn		= 7,

	kCommandSpritePush		= 16,
	kCommandSpriteImpact,
	kCommandSpritePickup,
	kCommandSpriteTouch,
	kCommandSpriteSight,
	kCommandSpriteProximity,
	kCommandSpriteExplode,

	kCommandSectorPush      = 32,
	kCommandSectorImpact,
	kCommandSectorEnter,
	kCommandSectorExit,

	kCommandWallPush        = 48,
	kCommandWallImpact,
	kCommandWallCross,

	kCommandNumbered		= 64,
};

// txId constants
enum {
	kTagNull			= 0,

	kTagTextOver 		= 3,

	kTagEndLevelA		= 4,
	kTagEndLevelB		= 5,

	kTagLightning		= 6,

	kTagTriggerStart	= 7,	// channel triggered at startup
	kTagTriggerMatch	= 8,	// channel triggered at startup for BloodBath mode
	kTagTriggerCoop		= 9,	// channel triggered at startup for Coop mode

	// REMOTE BOMBS: Channels 90-99 reserved
	kTagRemoteBomb1		= 90,
	kTagRemoteBomb10	= 99,

	kUserTagStart		= 100
};

struct EVENT {
	unsigned index 		: 13; 	// object array index (sprite[], sector[], wall[])
	unsigned type  		:  3;	// 0=sprite, 1=sector, 2=wall
	unsigned to       	: 10; 	// objects with matching rxID will receive message
	unsigned command  	:  6; 	// kCommandOn, kCommandOff, etc.
};

void evInit( void );
void evSend( int index, int type, int to, int command );
void evPost( int index, int type, ulong time, int command = kCommandCallback );
void evProcess( ulong time );

#endif // __EVENTQ_H
