#ifndef __SPRITEFX__
#define __SPRITEFX__

/****************************************************************************
** TYPEDEFS
****************************************************************************/
/** Monster Data **/
	typedef struct {
		short sprite;
		short target;
		long	targetX, targetY, targetZ;
		char 	state;
		char 	move;
		char 	health;
	} MONSTER;

/****************************************************************************
** CONSTANTS
****************************************************************************/

#define kAngleMask			2047
#define kAngle45				256
#define kAngle60				341
#define kAngle90				512
#define kAngle120				683
#define kAngle180				1024
#define kAngle270				1536
#define kAngle360				2048

/** Monster AI States **/
	enum {
		kAIScanSector = 0,
		kAIGoto       = 1,
		kAIFollow     = 2,
	};

/** Monster Movement States **/
	enum {
		kMoveStill		= 0,
		kMoveWalk		= 1,
		kMoveFly			= 2,
		kMoveJump		= 3,
		kMoveFall		= 4,
	};

/************************
** GLOBALS
************************/
extern short gMonsterCnt;
extern MONSTER gMonsters[kMaxSprites];

/************************
** GLOBAL PROTOTYPES
************************/
extern void  FX_InitSprites(void);
extern void  FX_MoveSprites(void);

extern short CanMove(short nSprite, short ang, long dist);
extern short MyMoveSprite(short nSprite);
extern void  WalkMonster(MONSTER *pMonster);

#endif //__SPRITEFX__
