/*******************************************************************************
	FILE:			SFX.H

	DESCRIPTION:	Sound Effects API

	AUTHOR:			Peter M. Freese
	CREATED:		11-07-95
	COPYRIGHT:		Copyright (c) 1995 Q Studios Corporation
*******************************************************************************/
#ifndef __SFX_H
#define __SFX_H
#include "typedefs.h"

enum
{
	kSfxGlassHit,
	kSfxPotteryHit,
	kSfxSwitch1,
	kSfxSwitch2,
	kSfxJump,
	kSfxLand,
	kSfxFall,
	kSfxProxArm,
	kSfxProxDet,
	kSfxRemoteDet,
	kSfxThingBurn,
	kSfxThingSplat,
	kSfxDrip1,
	kSfxDrip2,
	kSfxDrip3,
	kSfxExplode1,
	kMaxXSound,
};


/*******************************************************************************
Sound definition file format:

SoundNN="NAME.RAW", volume [, startloop, endloop ]

Each sound has a relative volume for it in the definition file.  This allows
all samples to be recorded as hot as possible.

The startloop and endloop values are optional, and apply only to sounds which
are to be looped.  Unless we determine a way to dynamically stop a sample from
looping and cause it to continue playing all the way through, the endloop
position should be the end of the sample.  Currently, ASL does not support this
feature.

*******************************************************************************/


/***********************************************************************
 * Function prototypes
 **********************************************************************/
extern void sfxInit( void );
/* Initialize the sound effect system.  Read user settings (volume, mix
channels, mix rate, etc.), initialize low level driver, and load sound mapping
from definition file. */

extern void sfxTerm( void );
/* Shut down the sound system.  Stops all sounds and deinitializes driver. */

extern void sfxStart3DSound( int nXSprite, int soundId, int nPitch = 0x10000 );
/* Starts a sound playing for a given XSprite.  The sound will supercede any
sound already playing for the XSprite. */

extern void sfxCreate3DSound( int x, int y, int z, int soundId, int nPitch = 0x10000 );
/* Create and start a 3D sound effect using a temporary structure. */

extern void sfxKill3DSound( int nXSprite );
/* Stops any sound playing for the specified XSprite.  Use this before warping
a sprite so it's sound doesn't get hosed from moving a large distance in a
short time period.*/

extern void sfxKillAll3DSounds( void );
/* Stops all 3D sound effects from playing. This might be used when ending a
level. */

extern void sfxUpdate3DSounds( void );
/* Update the 3D location of all 3D sound effects.  The warp flag indicates
whether the listener location actually moved or reappeared, and should be set
when teleporting and restarting the player. */

#endif //__SFX_H
