#include <conio.h>
#include <stdio.h>
#include <string.h>
#include "types.h"
#include "develop.h"
#include "sndcards.h"
#include "fx_man.h"
#include "music.h"
#include "scriplib.h"
#include "file_lib.h"
#include "gamedefs.h"
#include "keyboard.h"
#include "util_lib.h"

#include "control.h"
#include "config.h"
#include "sounds.h"
#include "function.h"

/*
===================
=
= Shutdown
=
===================
*/

void ShutDown( void )
   {
   KB_Shutdown();
   SoundShutdown();
   MusicShutdown();
   CONFIG_WriteSetup();
   }

/*
===================

=
= SetupGameButtons
=
===================
*/

void SetupGameButtons( void )
   {
   CONTROL_DefineFlag(gamefunc_Move_Forward,      false );
   CONTROL_DefineFlag(gamefunc_Move_Backward,     false );
   CONTROL_DefineFlag(gamefunc_Turn_Left,         false );
   CONTROL_DefineFlag(gamefunc_Turn_Right,        false );
   CONTROL_DefineFlag(gamefunc_Strafe,            false );
   CONTROL_DefineFlag(gamefunc_Strafe_Left,       false );
   CONTROL_DefineFlag(gamefunc_Strafe_Right,      false );
   CONTROL_DefineFlag(gamefunc_TurnAround,        false );
   CONTROL_DefineFlag(gamefunc_Jump,              false );
   CONTROL_DefineFlag(gamefunc_Crouch,            false );
   CONTROL_DefineFlag(gamefunc_Fire,              false );
   CONTROL_DefineFlag(gamefunc_Open,              false );
   CONTROL_DefineFlag(gamefunc_Look_Up,           false );
   CONTROL_DefineFlag(gamefunc_Look_Down,         false );
   CONTROL_DefineFlag(gamefunc_Aim_Up,            false );
   CONTROL_DefineFlag(gamefunc_Aim_Down,          false );
   CONTROL_DefineFlag(gamefunc_Run,               false );
   CONTROL_DefineFlag(gamefunc_SendMessage,       false );
   CONTROL_DefineFlag(gamefunc_Weapon_1,          false );
   CONTROL_DefineFlag(gamefunc_Weapon_2,          false );
   CONTROL_DefineFlag(gamefunc_Weapon_3,          false );
   CONTROL_DefineFlag(gamefunc_Weapon_4,          false );
   CONTROL_DefineFlag(gamefunc_Weapon_5,          false );
   CONTROL_DefineFlag(gamefunc_Weapon_6,          false );
   CONTROL_DefineFlag(gamefunc_Weapon_7,          false );
   CONTROL_DefineFlag(gamefunc_Weapon_8,          false );
   CONTROL_DefineFlag(gamefunc_Weapon_9,          false );
   CONTROL_DefineFlag(gamefunc_Weapon_10,         false );
   CONTROL_DefineFlag(gamefunc_Pause,             false );
   CONTROL_DefineFlag(gamefunc_Map,               false );
   CONTROL_DefineFlag(gamefunc_Look_Left,         false );
   CONTROL_DefineFlag(gamefunc_Look_Right,        false );
   CONTROL_DefineFlag(gamefunc_Gamma_Correction,  false );
   CONTROL_DefineFlag(gamefunc_Escape,            false );
   CONTROL_DefineFlag(gamefunc_Shrink_Screen,     false );
   CONTROL_DefineFlag(gamefunc_Enlarge_Screen,    false );
   CONTROL_DefineFlag(gamefunc_ScreenPeek,        false );
   CONTROL_DefineFlag(gamefunc_Transparent_Mode,  false );
   CONTROL_DefineFlag(gamefunc_AutoRun,           false );
   CONTROL_DefineFlag(gamefunc_Virtual_Mode,      false );
   CONTROL_DefineFlag(gamefunc_Center_View,       false );
   CONTROL_DefineFlag(gamefunc_Holster_Weapon,    false );
   CONTROL_DefineFlag(gamefunc_Inventory_Left,    false );
   CONTROL_DefineFlag(gamefunc_Inventory_Right,   false );
   CONTROL_DefineFlag(gamefunc_Holo_Duke,         false );
   CONTROL_DefineFlag(gamefunc_Jetpack,           false );
   CONTROL_DefineFlag(gamefunc_Powerup_Toggle,    false );
   CONTROL_DefineFlag(gamefunc_Inventory,         false );
   CONTROL_DefineFlag(gamefunc_Remote_Ridicule_1, false );
   CONTROL_DefineFlag(gamefunc_Remote_Ridicule_2, false );
   CONTROL_DefineFlag(gamefunc_Remote_Ridicule_3, false );
   CONTROL_DefineFlag(gamefunc_Remote_Ridicule_4, false );
   CONTROL_DefineFlag(gamefunc_Remote_Ridicule_5, false );
   CONTROL_DefineFlag(gamefunc_Remote_Ridicule_6, false );
   CONTROL_DefineFlag(gamefunc_Remote_Ridicule_7, false );
   CONTROL_DefineFlag(gamefunc_Remote_Ridicule_8, false );
   CONTROL_DefineFlag(gamefunc_Remote_Ridicule_9, false );
   CONTROL_DefineFlag(gamefunc_Remote_Ridicule_10,false );
   }

/*
===================
=
= GetTime
=
===================
*/

static int32 timert;

int32 GetTime(void)
   {
   return timert++;
   }

/*
===================
=
= CenterCenter
=
===================
*/

void CenterCenter(void)
   {
   printf("Center the joystick and press a button\n");
   }

/*
===================
=
= UpperLeft
=
===================
*/

void UpperLeft(void)
   {
   printf("Move joystick to upper-left corner and press a button\n");
   }

/*
===================
=
= LowerRight
=
===================
*/

void LowerRight(void)
   {
   printf("Move joystick to lower-right corner and press a button\n");
   }

void main()
   {
   char * song;
   char * voc;

   KB_Startup();
   CONFIG_GetSetupFilename();
   CONFIG_ReadSetup();
   CONTROL_Startup( ControllerType, &GetTime, 1500 );
   SetupGameButtons();
   MusicStartup();
   SoundStartup();

   // load in some test data

   LoadFile("test.mid",&song);
   LoadFile("test.voc",&voc);

   // start playing a song

   MUSIC_PlaySong( song, MUSIC_LoopSong );
   if (CONTROL_JoystickEnabled)
      CONTROL_CenterJoystick(CenterCenter,UpperLeft,LowerRight);


   while (1)
      {
      int32 i;
      ControlInfo info;

      CONTROL_GetButtonInput();
      CONTROL_GetMovementInput( &info );

      if (info.dyaw!=0 || info.dz!=0)
         printf("yaw=%8x z=%8x\n",info.dyaw,info.dz);
      // Get Keyboard input and set appropiate game function states
      for (i=0;i<NUMGAMEFUNCTIONS;i++)
         {
         if (BUTTON(i) && !BUTTONHELD(i))
            {
            printf("%s\n",gamefunctions[i]);
            }
         }
      // Check to see if fire is being pressed so we can play a sound
      if (BUTTON(gamefunc_Fire) && !BUTTONHELD(gamefunc_Fire))
         {
         FX_PlayVOC( voc, 0, 255, 255, 255, 255, 0);
         }

      // Check to see if we want to exit
      if ( BUTTON(gamefunc_Escape) )
         {
         break;
         }

      }

   ShutDown();
   }
