#ifndef __GFX_H
#define __GFX_H

#include "typedefs.h"
#include "helix.h"
#include "misc.h"


struct Point
{
	int x, y;
	Point(int x, int y) : x(x), y(y) {};
	Point& operator+=( const Point& p ) { x += p.x; y += p.y; return *this; }
	Point& operator-=( const Point& p ) { x -= p.x; y -= p.y; return *this; }
	BOOL operator==( const Point& p ) const { return x == p.x && y == p.y; }
};


struct Rect
{
	int x0, y0, x1, y1;
	Rect( void ) : x0(0), y0(0), x1(0), y1(0) {};
	Rect( int x0, int y0, int x1, int y1 ) : x0(x0), y0(y0), x1(x1), y1(y1) {};
	Rect( const Point& tl, const Point& br ) : x0(tl.x), y0(tl.y), x1(br.x), y1(br.y) {};
	BOOL isValid( void ) const { return x0 < x1 && y0 < y1; }
	BOOL isEmpty( void ) const { return !isValid(); }
	BOOL operator!( void ) const { return isEmpty(); }
	Rect& operator&=( Rect &r ) { x0 = ClipLow(x0, r.x0); y0 = ClipLow(y0, r.y0);
		x1 = ClipHigh(x1, r.x1); y1 = ClipHigh(y1, r.y1); return *this; }
	Rect& operator|=( Rect &r ) { x0 = ClipHigh(x0, r.x0); y0 = ClipHigh(y0, r.y0);
		x1 = ClipLow(x1, r.x1); y1 = ClipLow(y1, r.y1); return *this; }
	BOOL contains( int x, int y ) const { return x >= x0 && x < x1 && y >= y0 && y < y1; }
	BOOL contains( const Point& p ) const { return contains(p.x, p.y); }
	BOOL contains( const Rect& r ) const { return r.x0 >= x0 && r.x1 <= x1 && r.y0 >= y0 && r.y1 <= y1; }
	Rect& operator+=(const Point& p ) { x0 += p.x; y0 += p.y; x1 += p.x; y1 += p.y; return *this; }
	Rect& operator-=(const Point& p ) { x0 -= p.x; y0 -= p.y; x1 -= p.x; y1 -= p.y; return *this; }
};


class SaveUnder : public QBITMAP
{
	Rect r;
};



void gfxDrawBitmap( QBITMAP *qbm, int x, int y );
void gfxPixel( int x, int y );
void gfxHLine( int y, int x0, int x1 );
void gfxVLine( int x, int y0, int y1 );
void gfxHLineROP( int y, int x0, int x1 );
void gfxVLineROP( int x, int y0, int y1 );
void gfxFillBox( int x0, int y0, int x1, int y1 );
void gfxDrawLine( int x0, int y0, int x1, int y1, int nColor );
void gfxDrawPixel( int x, int y, int nColor );
void gfxSetClip( int x0, int y0, int x1, int y1 );
void gfxDrawText( int x, int y, int nForeColor, char *string );
void gfxDrawLabel( int x, int y, int nForeColor, char *string );

#endif
