/*******************************************************************************
	FILE:			GAMEUTIL.H

	DESCRIPTION:	This header file contains prototypes and inline
					declarations for utilities functions dealing with the
					BUILD engine.

	AUTHOR:			Peter M. Freese
	CREATED:		07-08-95
	COPYRIGHT:		Copyright (c) 1995 Q Studios Corporation
*******************************************************************************/

#ifndef __GAMEUTIL_H
#define __GAMEUTIL_H

#include "engine.h"
#include "typedefs.h"

struct HITINFO {
	short	hitsect;
	short	hitwall;
	short	hitsprite;
	long	hitx;
	long	hity;
	long	hitz;
};


/***********************************************************************
 * Inline functions
 **********************************************************************/

inline BOOL GotPic( int nTile )
{
	return (BOOL)(gotpic[nTile >> 3] & (1 << (nTile & 7)));
}


inline void ClearGotPic( int nTile )
{
	gotpic[ nTile >> 3 ] &= (BYTE)~(1 << (nTile & 7));
}


inline void SetGotPic( int nTile )
{
	gotpic[ nTile >> 3 ] |= (BYTE)(1 << (nTile & 7));
}


inline BOOL Show2dWall( int nWall )
{
	return (BOOL)(show2dwall[nWall >> 3] & (1 << (nWall & 7)));
}


inline BOOL Show2dSprite( int nSprite )
{
	return (BOOL)(show2dsprite[nSprite >> 3] & (1 << (nSprite & 7)));
}


// Euclidean 3D distance
inline int Dist3d(int dx, int dy, int dz)
{
	dx >>= 4;
	dy >>= 4;
	dz >>= 8;
	return ksqrt(dx * dx + dy * dy + dz * dz);
}


/***********************************************************************
 * GetSpriteExtents()
 *
 * Report the vertical size of a sprite in z units (works for all
 * sprite types)
 **********************************************************************/
inline void GetSpriteExtents( SPRITE *pSprite, int *zTop, int *zBot )
{
	*zTop = *zBot = pSprite->z;
	if ( (pSprite->cstat & kSpriteRMask) == kSpriteFloor )
		return;

	int nTile = pSprite->picnum;
	*zTop -= (picanm[nTile].ycenter + tilesizy[nTile] / 2) * (pSprite->yrepeat << 2);
	*zBot += (tilesizy[nTile] - (tilesizy[nTile] / 2 + picanm[nTile].ycenter)) * (pSprite->yrepeat << 2);
}


BOOL AreSectorsNeighbors(int sect1, int sect2);
void CalcFrameRate( void );
BOOL CheckProximity( SPRITE *pSprite, int x, int y, int z, int dist );
int GetWallAngle( int nWall );
void GetWallNormal( int nWall, int *nx, int *ny );
int HitScan( SPRITE *pSprite, int startZ, int dx, int dy, int dz, HITINFO *hitInfo );
void GetZRange( SPRITE *pSprite, long *ceilZ, long *ceilHit, long *floorZ, long *floorHit, char cliptype );
unsigned ClipMove( long *px, long *py, long *pz, short *pnSector, long dx, long dy,
	int wallDist, int ceilDist, int floorDist, char clipType );

#endif

