#include <string.h>
#include <dos.h>

#include "sfx.h"
#include "db.h"
#include "globals.h"
#include "sound.h"
#include "engine.h"
#include "error.h"
#include "fx_man.h"
#include "player.h"
#include "gameutil.h"
#include "trig.h"
#include "globals.h"
#include "misc.h"
#include "debug4g.h"

// sample rate in samples / sec
#define kSampleRate		11110

// sound of sound in XY units / sec
#define kSoundVel		M2X(343.0)

// sound of sound in XY units / frame interval
#define kSoundVelFrame	(kSoundVel * kFrameTicks / kTimerRate)

// Intra-aural delay in seconds
#define kIntraAuralTime	0.0006

// Intra-aural distance based on delay and speed of sound
#define kIntraAuralDist	(kIntraAuralTime / 2 * kSoundVel)

// 16:16 fixed point constant for convert XY distance to sample phase
#define kDistPhase		((kSampleRate << 16) / kSoundVel)

// scale value for all 3D sounds
#define kVolScale		256

#define kBackFilter 	0x8000

int gPinnaAngle = kAngle45;

static POINT2D earL, earR, earL0, earR0;
static VECTOR2D earVL, earVR;
static int lPhase, rPhase, lVol, rVol;
static int lVel, rVel;

struct XSOUND
{
	char *name;
	uchar relVol;
	RESHANDLE hResource;
};

XSOUND xsound[kMaxXSound] =
{
	{ "GLASSHIT", 120 },	// kSfxGlassHit
	{ "POTTERY", 80 },		// kSfxPotteryHit
	{ "SWITCH", 40 },		// kSfxSwitch1
	{ "SWITCH5", 40 },		// kSfxSwitch2
	{ "JUMP", 50 },			// kSfxJump
	{ "LAND", 50 },			// kSfxLand
	{ "FALL", 80 },			// kSfxFall
	{ "TNT_PROX", 60 }, 	// kSfxProxArm
	{ "TNT_ARM", 80 },  	// kSfxProxDet
	{ "TNT_DET", 80 },  	// kSfxRemoteDet
	{ "BDY_BURN", 50 },		// kSfxThingBurn
	{ "BDY_SPLG", 50 },		// kSfxThingSplat
	{ "DRIPSURF", 20 },		// kSfxDrip1
	{ "DRIPWAT4", 20 },		// kSfxDrip2
	{ "DRIPWAT5", 20 },		// kSfxDrip3
	{ "BOOM1", 200 },		// kSfxExplode1
};

class SAMPLE3D : public SAMPLE
{
public:
	BYTE *pRaw;
	virtual void callback( void );
};

struct SPEAKER
{
	SAMPLE3D left, right;
	int x, y, z;
};


SPEAKER Speaker[kMaxXSprites];


virtual void SAMPLE3D::callback( void )
{
	Resource::Free(pRaw);
	pRaw = NULL;
	hVoice = 0;
}


void sfxInit( void )
{
	for (int i = 0; i < kMaxXSound; i++)
	{
		xsound[i].hResource = gSysRes.Lookup(xsound[i].name, ".RAW");
	}
}


void sfxTerm( void )
{
}


void sfxKillAllSounds( void )
{
}


/*******************************************************************************

Here is the equation for determining the frequency shift of a sound:

	                    
	             v + vL 
	    fL = fS   
	             v + vS 
	                    

Where:

	fL	= frequency as heard by the listener
	fS	= frequency of the source
	v	= velocity of sound
	vL	= velocity of listener
	vS	= velocity of source

Velocities are measured on a vector from the listener to the source.

Speed of sound at STP = 343 m/s = 1126 ft/s.

*******************************************************************************/

/*
#define kSoundVelocity	((double)kSampleRate / kTimerRate)
int Freq( int velocity )
{
	return kSampleRate * kSoundVelocity / (ClipLow(kSoundVelocity - velocity, 1));
}
*/


inline int FreqShift( int nPitch, int vL )
{
	return muldiv(nPitch, kSoundVelFrame + vL, kSoundVelFrame);
}


static int Vol3d(int nAngle, int vol)
{
	return vol - mulscale16(vol, kBackFilter / 2 - mulscale30(kBackFilter / 2, Cos(nAngle)));
}


void Calc3DValues( int x, int y, int z, int relVol )
{
	int dx, dy, dz, dist, nAngle;

	dx = x - gMe->sprite->x;
	dy = y - gMe->sprite->y;
	dz = z - gMe->sprite->z;
	nAngle = getangle(dx, dy);
	dist = ClipLow(Dist3d(dx, dy, dz), 1);
	int monoVol = muldiv(relVol, kVolScale, dist);

	// normal vector for listener -> source
	dx = Cos(nAngle);
	dy = Sin(nAngle);

	int lDist = qdist(x - earL.x, y - earL.y);
	lVol = Vol3d(nAngle - (gMe->sprite->ang - gPinnaAngle), monoVol);
	lPhase = mulscale16r(lDist, kDistPhase);
	lVel = dmulscale30r(dx, earVL.dx, dy, earVL.dy);

	int rDist = qdist(x - earR.x, y - earR.y);
	rVol = Vol3d(nAngle - (gMe->sprite->ang + gPinnaAngle), monoVol);
	rPhase = mulscale16r(rDist, kDistPhase);
	rVel = dmulscale30r(dx, earVR.dx, dy, earVR.dy);
}

/*
void UpdateSound( void )
{
	if (lVoice > FX_Ok)
	{
		FX_SetPan(lVoice, lVol, lVol, 0);
		FX_SetFrequency(lVoice, Freq(lVel));
	}

	if (rVoice > FX_Ok)
	{
		FX_SetPan(rVoice, rVol, 0, rVol);
		FX_SetFrequency(rVoice, Freq(rVel));
	}
}
*/


void sfxStart3DSound( int nXSprite, int soundId, int nPitch )
{
	if ( gFXDevice == -1 )
		return;

	if ( soundId < 0 || soundId >= kMaxXSound )
		ThrowError("Invalid sound ID", ES_ERROR);

	XSOUND *pXSound = &xsound[soundId];

	dassert(nXSprite > 0 && nXSprite < kMaxXSprites);
	SPEAKER *pSpeaker = &Speaker[nXSprite];

	// if there is an active voice, kill the sound
	if ( pSpeaker->left.hVoice > 0 )
		FX_StopSound(pSpeaker->left.hVoice);
	if ( pSpeaker->right.hVoice > 0 )
		FX_StopSound(pSpeaker->right.hVoice);

	SPRITE *pSprite = &sprite[xsprite[nXSprite].reference];
	Calc3DValues(pSprite->x, pSprite->y, pSprite->z, pXSound->relVol);

	RESHANDLE hResource = pXSound->hResource;

	int sampleSize = gSysRes.Size(hResource);
	char *pRaw = (char *)gSysRes.Lock(hResource);
	nPitch = mulscale16(nPitch, kSampleRate);

	pSpeaker->left.pRaw = (BYTE *)Resource::Alloc(sampleSize + lPhase);
	memset(pSpeaker->left.pRaw, 128, lPhase);
	memcpy(&pSpeaker->left.pRaw[lPhase], pRaw, sampleSize);

	pSpeaker->right.pRaw = (BYTE *)Resource::Alloc(sampleSize + rPhase);
	memset(pSpeaker->right.pRaw, 128, rPhase);
	memcpy(&pSpeaker->right.pRaw[rPhase], pRaw, sampleSize);

	gSysRes.Unlock(hResource);

	int nPriority = 1;	// ASS seems to choke if this is less than 1, e.g., 0
	if ( lVol > nPriority )
		nPriority = lVol;
	if ( rVol > nPriority )
		nPriority = rVol;

	_disable();	// make sure the samples start in the same interval

	pSpeaker->left.hVoice = FX_PlayRaw(
		pSpeaker->left.pRaw, sampleSize + lPhase, FreqShift(nPitch, lVel), 0,
		lVol, lVol, 0, nPriority, (ulong)(&pSpeaker->left));

	pSpeaker->right.hVoice = FX_PlayRaw(
		pSpeaker->right.pRaw, sampleSize + rPhase, FreqShift(nPitch, rVel), 0,
		rVol, 0, rVol, nPriority, (ulong)(&pSpeaker->right));

	_enable();	// allow them to start

	// did it fail?
	if ( pSpeaker->left.hVoice <= 0 )
		Resource::Free(pSpeaker->left.pRaw);

	if ( pSpeaker->right.hVoice <= 0 )
		Resource::Free(pSpeaker->right.pRaw);
}

/*
void sfxCreate3DSound( int x, int y, int z, int soundId )
{
}
*/

void sfxKill3DSound( int nXSprite )
{
	if ( gFXDevice == -1 )
		return;

	dassert(nXSprite > 0 && nXSprite < kMaxXSprites);
	SPEAKER *pSpeaker = &Speaker[nXSprite];

	// if there is an active voice, kill the sound
	if ( pSpeaker->left.hVoice > 0 )
		FX_StopSound(pSpeaker->left.hVoice);
	if ( pSpeaker->right.hVoice > 0 )
		FX_StopSound(pSpeaker->right.hVoice);
}

/*
void sfxKillAll3DSounds( void )
{
}
*/

// ear distance (in samples)
#define kEarLX (int)(-kIntraAuralTime / 2 * kSampleRate)
#define kEarRX (int)(+kIntraAuralTime / 2 * kSampleRate)

void sfxUpdate3DSounds( void )
{
	// update listener ear positions
	int earDX, earDY;

	earDX = mulscale30(Cos(gMe->sprite->ang + kAngle90), kIntraAuralDist);
	earDY = mulscale30(Sin(gMe->sprite->ang + kAngle90), kIntraAuralDist);

	earL0 = earL;
	earL.x = gMe->sprite->x - earDX;
	earL.y = gMe->sprite->y - earDY;
	earR0 = earR;
	earR.x = gMe->sprite->x + earDX;
	earR.y = gMe->sprite->y + earDY;

	// update ear velocities
	earVL.dx = earL.x - earL0.x;
	earVL.dy = earL.y - earL0.y;

	earVR.dx = earR.x - earR0.x;
	earVR.dy = earR.y - earR0.y;
}

