/*******************************************************************************
	FILE:			CREDITS.CPP

	DESCRIPTION:

	AUTHOR:			Peter M. Freese
	CREATED:		12-05-95
	COPYRIGHT:		Copyright (c) 1995 Q Studios Corporation
*******************************************************************************/

#include "credits.h"
#include "key.h"
#include "sound.h"
#include "screen.h"
#include "globals.h"
#include "misc.h"
#include "debug4g.h"

#define kDACWaitTicks	2	// ticks between DAC updates

static BOOL Wait( int nTicks )
{
	gGameClock = 0;
	while ( gGameClock < nTicks )
		if ( keyGet() != 0 )
			return FALSE;
	return TRUE;
}


static BOOL DoFade( BYTE r, BYTE g, BYTE b, int nTicks )
{
	dassert(nTicks > 0);
	scrSetupFade(r, g, b);
	gGameClock = gFrameClock = 0;
	do
	{
		while (gGameClock < gFrameClock);
		gFrameClock += kDACWaitTicks;

		WaitVSync();
		scrFadeAmount(divscale16(ClipHigh(gGameClock, nTicks), nTicks));

		if ( keyGet() != 0 )
			return FALSE;
	} while ( gGameClock <= nTicks );
	return TRUE;
}

static BOOL DoUnFade( int nTicks )
{
	dassert(nTicks > 0);
	scrSetupUnfade();
	gGameClock = gFrameClock = 0;
	do
	{
		while (gGameClock < gFrameClock);
		gFrameClock += kDACWaitTicks;

		WaitVSync();
		scrFadeAmount(0x10000 - divscale16(ClipHigh(gGameClock, nTicks), nTicks));

		if ( keyGet() != 0 )
			return FALSE;
	} while ( gGameClock <= nTicks );
	return TRUE;
}

// show logos
void credLogos( void )
{
	int nEffect = 0;

//	sndPlaySong("INTRO", FALSE);

	// black out dac
	if ( !DoFade(0, 0, 0, 1) ) return;

	clearview(0);

	// castle background
	rotatesprite(320 << 15, 200 << 15, 0x10000, 0, 2046, 0, 0,
		kRotateScale | kRotateNoMask, 0, 0, 319, 199);
	scrNextPage();

	if ( !DoUnFade(2 * kTimerRate) ) return;
	if ( !Wait(1 * kTimerRate) ) return;

	if ( !DoFade(255, 255, 255, 2) ) return;

/*
	// flash the subliminal babe
	rotatesprite(320 << 15, 200 << 15, 0x10000, 0, 2323, 0, 0,
		kRotateScale | kRotateNoMask, 0, 0, 319, 199);
	scrNextPage();
	DoUnFade(1);
	DoFade(255, 255, 255, 1);
*/

	// castle again
	rotatesprite(320 << 15, 200 << 15, 0x10000, 0, 2046, 0, 0,
		kRotateScale | kRotateNoMask, 0, 0, 319, 199);
	// Q Studios logo
	rotatesprite(320 << 15, 200 << 15, 0x10000, 0, 2047, 0, 0,
		kRotateScale | kRotateNoMask, 0, 0, 319, 199);
	scrNextPage();

	sndStartSample("THUNDER2", 255);

	if ( !DoUnFade(60) ) return;

	if ( !Wait(1 * kTimerRate) ) return;
	sndStartSample("THUNDER", 255);
	if ( !Wait(1 * kTimerRate) ) return;
	if ( !DoFade(0, 0, 0, 60) ) return;

	// menu background
	rotatesprite(320 << 15, 200 << 15, 0x10000, 0, 2049, 0, 0,
		kRotateScale | kRotateNoMask, 0, 0, 319, 199);
	scrNextPage();

	if ( !DoUnFade(60) ) return;
	sndStartSample("DOORSLID", 255);
	if ( !Wait(2 * kTimerRate) ) return;
	if ( !DoFade(0, 0, 0, 60) ) return;

	while ( sndIsSongPlaying() )
	{
		if (keyGet() != 0 )
			return;
	}
}


