/*******************************************************************************
	FILE:			CREDITS.CPP

	DESCRIPTION:

	AUTHOR:			Peter M. Freese
	CREATED:		12-05-95
	COPYRIGHT:		Copyright (c) 1995 Q Studios Corporation
*******************************************************************************/

#include "credits.h"
#include "key.h"
#include "sound.h"
#include "screen.h"
#include "globals.h"
#include "misc.h"
#include "debug4g.h"


static void Wait( int nTicks )
{
	gGameClock = 0;
	while ( gGameClock < nTicks )
		if ( keyGet() != 0 )
			return;
}


static void DoFade( BYTE r, BYTE g, BYTE b, int nTicks )
{
	dassert(nTicks > 0);
	scrSetupFade(r, g, b);
	gGameClock = gFrameClock = 0;
	do
	{
		while (gGameClock < gFrameClock);
		gFrameClock += 4;

		scrFadeAmount(divscale16(ClipHigh(gGameClock, nTicks), nTicks));

		if ( keyGet() != 0 )
			return;
	} while ( gGameClock <= nTicks );
}

static void DoUnFade( int nTicks )
{
	dassert(nTicks > 0);
	scrSetupUnfade();
	gGameClock = gFrameClock = 0;
	do
	{
		while (gGameClock < gFrameClock);
		gFrameClock += 4;

		scrFadeAmount(0x10000 - divscale16(ClipHigh(gGameClock, nTicks), nTicks));

		if ( keyGet() != 0 )
			return;
	} while ( gGameClock <= nTicks );
}

// show logos
void credLogos( void )
{
	int nEffect = 0;

	sndPlaySong("INTRO", FALSE);

	gGameClock = 0;

	// black out dac
	DoFade(0, 0, 0, 1);

	clearview(0);
	rotatesprite(320 << 15, 200 << 15, 0x10000, 0, 2047, 0, 0,
		kRotateScale | kRotateNoMask, 0, 0, 319, 199);
	scrNextPage();

	// wait a bit
	Wait(160);

	DoFade(255, 255, 255, 30);
	DoUnFade(90);
	Wait(4 * kTimerRate);
	DoFade(0, 0, 0, 2 * kTimerRate);

	while ( sndIsSongPlaying() )
	{
		if (keyGet() != 0 )
			return;
	}
}


