#ifndef __ANIM_H
#define __ANIM_H

#include "helix.h"
#include "typedefs.h"
#include "stdlib.h"


enum
{
	kQFrameTile		= 0L,
	kQFrameSound,
	kQFrameTrigger,
};


enum
{
	// begin rotatesprite compatible flags
	kQFrameNormal			= 0L,		// no flags
	kQFrameTranslucent		= 0x01L,	// frame is translucent
	kQFrameScale			= 0x02L,	// frame is scaled to viewing window
	kQFrameXFlip			= 0x04L,	// frame is x-flipped
	kQFrameUnclipped		= 0x08L,	// frame is not clipped to umost/dmost
	kQFrameCorner			= 0x10L,	// frame is positioned by top left corner instead of origin
	kQFrameStatus			= 0x0AL,	// frame is not masked (used for status bar)
	kQFrameTranslucentR		= 0x20L,	// frame is translucent, using reverse translucency table

	// begin internal flags
	kQFrameYFlip			= 0x20L,	// frame is y-flipped
};


struct FRAME
{
	long			timeStart;
	long			timeStop;
	int				type;
	int				id;
	int				flags;
	union
	{
		// type = kQFrameTile
		struct
		{
			int		x, y;
			int		layer;
			int		shade;
			int		pal;
//			long	zoom;	// zoom in 16:16 fixed format
//			short	angle;	// angle in Build units (0 is straight up)
		};

		// type = kQFrameSound
		struct
		{
			int		priority;
			int		volume;
			int		soundID;
		};

		// type = kQFrameTrigger
		struct {
			int		trigger;
		};
	};
};


typedef void (*PLAY_PROC)( FRAME * pFrame );


struct Anim
{
	char 	signature[4];
	short 	version;
	char	dummy[2];

	int		frames;
	long	duration;
	int		backTile;
	POINT	origin;
	FRAME	frame[1];

	void	DrawFrame( FRAME *, int shade, int flags );
	void	Play( ulong t0, ulong t1, int shade, int flags, PLAY_PROC callback = NULL );
	void	Preload( void );
};

#endif
