#ifndef _wndolib_public_
#define _wndolib_public_

//
// Defines
//

#define MAXMENUWIDTH  78
#define MAXMENUHEIGHT 23

void StartWindows ( void );
void ShutdownWindows ( void );
void DrawWindow( int32 windowhandle );
int32 OpenWindow
   (
   int32 x,
   int32 y,
   int32 width,
   int32 height,
   int32 foreground,
   int32 background
   );
int32 OpenCenteredWindow
   (
   int32 width,
   int32 height,
   int32 foreground,
   int32 background
   );
void CloseWindow( int32 windowhandle );
int32 WindowsOpen( void );
void DrawWindowDivider( int32 windowhandle, int32 yoffset );
int32 DrawWindowString
   (
   int32 windowhandle,
   int32 xoffset,
   int32 yoffset,
   char * string,
   int32 foreground,
   int32 background
   );

int32 DrawWindowCenteredString
   (
   int32 windowhandle,
   int32 yoffset,
   char * string,
   int32 foreground,
   int32 background
   );

int32 WindowBackgroundColor( int32 windowhandle );
int32 WindowForegroundColor( int32 windowhandle );

int32 WindowHeight( int32 windowhandle );
int32 WindowWidth( int32 windowhandle );

void  ClearWindowLine( int32 windowhandle, int32 y );

void GetWindowCharacter
   (
   int32 windowhandle,
   int32  x,
   int32  y,
   int32 * ch,
   int32 * foreground,
   int32 * background
   );

void DrawWindowCharacter
   (
   int32 windowhandle,
   int32 xoffset,
   int32 yoffset,
   char  ch,
   int32 foreground,
   int32 background
   );

int32 DrawWindowBlock
   (
   int32 windowhandle,
   int32 xoffset,
   int32 yoffset,
   char * block,
   int32 foreground,
   int32 background
   );

int32 DrawWindowCenteredBlock
   (
   int32 windowhandle,
   int32 yoffset,
   char * block,
   int32 foreground,
   int32 background
   );

#endif

