#ifndef _config_public
#define _config_public

#define SETUPNAMEPARM "SETUPFILE"

// screen externs
extern int32 ScreenMode; // Screen mode
extern int32 ScreenWidth;
extern int32 ScreenHeight;
extern int32 ScreenBufferMode;
extern int32 VesaBufferMode;

// sound externs
extern int32 FXDevice; // Sound FX Card number
extern int32 MusicDevice; // Music Card number
extern int32 FXVolume; // FX Volume
extern int32 MusicVolume; // Music Volume
extern int32 NumVoices; // Number of voices
extern int32 NumChannels; // Number of channels
extern int32 NumBits; // Number of bits
extern int32 MixRate; // Mixing rate
extern int32 MidiPort; // Midi Port
extern fx_blaster_config BlasterConfig; // Blaster settings
extern int32 ReverseStereo; // Reverse Stereo Channels

// comm externs
extern int32 ComPort;
extern int32 IrqNumber;
extern int32 UartAddress;
extern int32 PortSpeed;

extern int32 ToneDial;
extern char  ModemName[MAXMODEMSTRING];
extern char  InitString[MAXMODEMSTRING];
extern char  HangupString[MAXMODEMSTRING];
extern char  DialoutString[MAXMODEMSTRING];
extern int32 SocketNumber;
extern char  CommbatMacro[MAXMACROS][MAXMACROLENGTH];
extern char  PhoneNames[MAXPHONEENTRIES][PHONENAMELENGTH];
extern char  PhoneNumbers[MAXPHONEENTRIES][PHONENUMBERLENGTH];
extern char  PhoneNumber[PHONENUMBERLENGTH];
extern int32 NumberPlayers;
extern int32 ConnectType;
extern char  PlayerName[MAXPLAYERNAMELENGTH];

// controller externs
extern int32 ControllerType;
extern int32 JoystickPort;
extern int32 MouseSensitivity;

extern char  MouseButtons[MAXMOUSEBUTTONS][MAXFUNCTIONLENGTH];
extern char  MouseButtonsClicked[MAXMOUSEBUTTONS][MAXFUNCTIONLENGTH];

extern char  JoystickButtons[MAXJOYBUTTONS][MAXFUNCTIONLENGTH];
extern char  JoystickButtonsClicked[MAXJOYBUTTONS][MAXFUNCTIONLENGTH];

extern char  setupfilename[128];

void SetMouseDefaults( void );
void SetJoystickDefaults( void );
void SetDefaultKeyDefinitions( void );

void ReadSetup( void );
void WriteSetup( boolean docomments );
void WriteCommitFile( int32 gametype );
void GetSetupFilename( void );

#endif
