#include <conio.h>
#include <io.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "types.h"
#include "develop.h"
#include "file_lib.h"
#include "util_lib.h"
#include "keyboard.h"
#include "scriplib.h"
#include "linklist.h"
#include "common.h"
#include "gamedefs.h"

int32 NumGameFunctions;
int32 writehandle;

/*
===================
=
= WriteString
=
===================
*/
void WriteString ( char * string )
   {
   int32 length;

   length = strlen(string);
   SafeWrite(writehandle,string,length);
   }


/*
===================
=
= WriteHeader
=
===================
*/
void WriteHeader( void )
   {
   WriteString("// file created by makehead.exe\n");
   WriteString("// this header contains default key assignments, as well as\n");
   WriteString("// default button assignments and game function names\n\n\n");
   }

/*
===================
=
= WriteEnums
=
===================
*/
void WriteEnums( void )
   {
   char str[80];
   int32 entry;

   WriteString("\n#define NUMGAMEFUNCTIONS ");
   sprintf(str,"%ld\n\n",NumGameFunctions);
   WriteString(str);

   WriteString("extern char * gamefunctions[];\n\n");
   if (SafeFileExists("function.ini"))
      {
      LoadScript ( "function.ini", true );
      WriteString("typedef enum\n");
      WriteString("   {\n");
      for (entry=0;entry<NumGameFunctions;entry++)
         {
         GetToken(true,true);
         WriteString("   gamefunc_");
         WriteString(token);
         WriteString(",\n");
         }
      WriteString("   };\n");
      FreeScript();
      }
   else
      {
      Error("function.ini not found\n");
      }
   }

/*
===================
=
= StoreDefaultKeyDefinitions
=
===================
*/
void StoreDefaultKeyDefinitions( void )
   {
   int32 numkeyentries;
   int32 i;
   char * functionname;
   char str[80];
   char keyname1[80];
   char keyname2[80];

   if (SafeFileExists("default.ini"))
      {
      LoadScript ( "default.ini", false );
      numkeyentries = NumberOfScriptEntries( "DefaultDefinitions" );

      WriteString("\n#define NUMKEYENTRIES ");
      sprintf(str,"%ld\n\n",numkeyentries);
      WriteString(str);
      WriteString("static char * keydefaults[] =\n");
      WriteString("   {\n");
      for (i=0;i<numkeyentries;i++)
         {
         functionname = ScriptEntry( "DefaultDefinitions", i );
         memset(keyname1,0,sizeof(keyname1));
         memset(keyname2,0,sizeof(keyname2));
         GetScriptDoubleString( "DefaultDefinitions", functionname, keyname1, keyname2);
         WriteString("   \"");
         WriteString(functionname);
         WriteString("\", ");
         WriteString("\"");
         WriteString(keyname1);
         WriteString("\", ");
         WriteString("\"");
         WriteString(keyname2);
         WriteString("\", \n");
         }
      WriteString("   };\n");
      FreeScript();
      }
   else
      {
      Error("default.ini not found");
      }
   }

/*
===================
=
= StoreButtonDefaults
=
===================
*/
void StoreButtonDefaults( void )
   {
   int32 i;
   char functionname[80];
   char str[80];

   if (SafeFileExists("default.ini"))
      {
      LoadScript ( "default.ini", false );

      WriteString("\n\nstatic char * mousedefaults[] =\n");
      WriteString("   {\n");
      for (i=0;i<MAXMOUSEBUTTONS;i++)
         {
         sprintf(str,"MouseButton%ld",i);
         GetScriptString( "DefaultButtons", str,functionname);
         WriteString("   \"");
         WriteString(functionname);
         WriteString("\",\n");
         }
      WriteString("   };\n");
      WriteString("\n\nstatic char * mouseclickeddefaults[] =\n");
      WriteString("   {\n");
      for (i=0;i<MAXMOUSEBUTTONS;i++)
         {
         sprintf(str,"MouseButtonClicked%ld",i);
         GetScriptString( "DefaultButtons", str,functionname);
         WriteString("   \"");
         WriteString(functionname);
         WriteString("\",\n");
         }
      WriteString("   };\n");
      WriteString("\n\nstatic char * joystickdefaults[] =\n");
      WriteString("   {\n");
      for (i=0;i<MAXJOYBUTTONS;i++)
         {
         sprintf(str,"JoystickButton%ld",i);
         GetScriptString( "DefaultButtons", str,functionname);
         WriteString("   \"");
         WriteString(functionname);
         WriteString("\",\n");
         }
      WriteString("   };\n");
      WriteString("\n\nstatic char * joystickclickeddefaults[] =\n");
      WriteString("   {\n");
      for (i=0;i<MAXJOYBUTTONS;i++)
         {
         sprintf(str,"JoystickButtonClicked%ld",i);
         GetScriptString( "DefaultButtons", str,functionname);
         WriteString("   \"");
         WriteString(functionname);
         WriteString("\",\n");
         }
      WriteString("   };\n");
      FreeScript();
      }
   else
      {
      Error("default.ini not found");
      }
   }

/*
===================
=
= StoreFunctions
=
===================
*/
void StoreFunctions( void )
   {
   int32 entry;

   if (SafeFileExists("function.ini"))
      {
      LoadScript ( "function.ini", true );
      NumGameFunctions = CountLinesInFile();
      WriteString("char * gamefunctions[] =\n");
      WriteString("   {\n");
      for (entry=0;entry<NumGameFunctions;entry++)
         {
         GetToken(true,true);
         WriteString("   \"");
         WriteString(token);
         WriteString("\",\n");
         }
      WriteString("   };\n");
      FreeScript();
      }
   else
      {
      Error("function.ini not found\n");
      }
   }


/*
===================
=
= Shutdown
=
===================
*/

void ShutDown( void )
   {
   }

void main( void )
   {
   writehandle=SafeOpenWrite("function.c",filetype_text);
   WriteString("// function.c\n\n");
   WriteHeader();
   StoreFunctions();
   StoreDefaultKeyDefinitions();
   StoreButtonDefaults();
   SafeClose(writehandle);

   writehandle=SafeOpenWrite("function.h",filetype_text);
   WriteString("// function.h\n\n");
   WriteHeader();
   WriteString("#ifndef _function_public_\n");
   WriteString("#define _function_public_\n");
   WriteEnums();
   WriteString("#endif\n");
   SafeClose(writehandle);
   }
