//***************************************************************************
//
//    WAD.C - Wad managment utilities
//
//***************************************************************************

#ifndef _wad_public
#define _wad_public

#define WAD_LUMP_NOT_FOUND ( 0xffffffff )

word    WAD_GetWADCRC( void );                     // Calculates the CRC of the wad info

void    WAD_InitMultipleFiles( char **filenames ); // Initialize multiple wads
void    WAD_InitFile( char *filename );            // Init a single wad file

int32   WAD_CheckNumForName( char *name );         // Check to see if the named lump exists
int32   WAD_GetNumForName( char *name );           // Get the number for the named lump
char   *WAD_GetNameForNum( int32 lump );           // Get the name for a number

int32   WAD_NumLumps( void );                      // Get the current number of lumps managed
int32   WAD_LumpLength( int32 lump );              // Get the length of the numbered lump
void    WAD_ReadLump( int32 lump, void *dest );    // Read the numbered lump into a buffer
void    WAD_WriteLump( int32 lump, void *src );

void   *WAD_CacheLumpNum( int32 lump, int32 zone, int32 tag );             // Cache in the numbered lump with the appropriate memory tag
void   *WAD_CacheLumpName( char *name, int32 zone, int32 tag );            // Cache in the named lump with the appropriate memory tag
void   *WAD_CacheLumpDec( char *name, int32 num, int32 zone, int32 tag );  // Cache in the named lump with decimal the appropriate memory tag
void   *WAD_CacheLumpHex( char *name, int32 num, int32 zone, int32 tag );  // Cache in the named lump with hexidecimal the appropriate memory tag
void   WAD_OpenWadFile (char * filename, boolean quiet);
void WAD_WriteWadLump
   (
   byte * data,
   int32 size,
   char * name,
   int32 lumptype,
   boolean quiet
   );
void   WAD_CloseWadFile ( boolean quiet );
void   WAD_ShootWAD( char *filename, boolean quiet );
char * WAD_LumptypeToString ( int32 lumptype );

#endif