
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>

#include "types.h"
#include "comm.h"
#include "keyboard.h"

char typebuffer[256];
int32 buffersize;
int32 drawx;
int32 drawy;

/*
====================
=
= TextMode
=
====================
*/

void TextMode ( void )
   {
   union REGS regs;

   regs.w.ax = 0x03;
   int386(0x10,&regs,&regs);
   }

/*
=================
=
= PrintXYString
=
=================
*/

void PrintXYString (int32 x, int32 y, byte *str)
   {
   byte *s;
   byte *screen;

   s = str;
   screen = (byte *)(0xB8000 + (y*160) + (x<<1));

   while (*s)
      {
      *screen = *s;
      x++;
      s++;
      if (x==80)
         {
         x=0;
         y++;
         if (y==25)
            {
            y=0;
            }
         screen = (byte *)(0xB8000 + (y*160) + (x<<1));
         }
      else
         {
         screen += 2;
         }

      while ((*s < 32) && (*s > 0))
         s++;
      }
   }

void DrawUserInput ( void )
   {
   PrintXYString (0, 0,
                  "                                        "
                  "                                        "
                  "                                        "
                  "                                        "
                 );
   typebuffer[buffersize]=0;
   PrintXYString (0, 0, &typebuffer[0]);
   }

void DrawRemoteInput ( void )
   {
   char str[300];

   sprintf (str,"PLAYER %ld: ",comm.sender);

   PrintXYString (drawx, drawy,
                  "                                        "
                  "                                        "
                  "                                        "
                  "                                        "
                 );
   PrintXYString (drawx, drawy,str);
   if (comm.badpacket == true)
     {
     PrintXYString (strlen(str), drawy, "Bad Packet");
     PrintXYString (strlen(str)+strlen("Bad Packet "), drawy, comm.packet);
     }
   else
     {
     PrintXYString (strlen(str), drawy, comm.packet);
     }
   drawy +=2;
   if (drawy>23)
      drawy=2;
   }

void SendBuffer ( int32 dest )
   {
   int32 i;

   typebuffer[buffersize]=0;
   //
   // Skip over null character
   //
   buffersize++;

   if (buffersize > 1)
      {
      WritePacket (&typebuffer[0], buffersize, dest);
/*
      // Echo it locally
      comm.badpacket = false;
      memcpy(&comm.packet[0],&typebuffer[0],buffersize);
      comm.sender = comm.consoleplayer;
      comm.packetlength = buffersize;
      DrawRemoteInput();
*/
      }
   buffersize = 0;
   typebuffer[buffersize]=0;
   DrawUserInput ();
   }

void ShutDown ( void )
   {
   KB_Shutdown();
   }

void main ( void )
   {
   boolean done;
   int32 keypress;

   done=false;
   KB_Startup();
   InitGAMECOM();
   if (!GAMECOMActive())
      {
      exit(0);
      }
   TextMode();
   buffersize = 0;
   drawx=0;
   drawy=2;

   while (done == false)
      {
      if (KB_KeyWaiting() == true)
         {
         keypress=KB_Getch();
         if (keypress == 8) // Delete key
            {
            if (buffersize>0)
               {
               buffersize--;
               }
            DrawUserInput ();
            }
         else if (keypress == 13)
            {
            SendBuffer(-1);
            }
         else if (keypress == 9)
            {
            SendBuffer(1);
            }
         else if (keypress == 27)
            {
            done = true;
            }
         else
            {
            typebuffer[buffersize++]=keypress;
            DrawUserInput ();
            }
         }
      if (ReadPacket() == true)
         {
         DrawRemoteInput();
         }
      }

   ShutDown();
   }
