#include <malloc.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include "types.h"
#include "sndcards.h"
#include "fx_man.h"
#include "music.h"
#include "util_lib.h"
#include "gamedefs.h"
#include "config.h"

void TestCallBack(unsigned long num)
{
  num = num;
}

/*
===================
=
= SoundStartup
=
===================
*/

void SoundStartup( void )
   {
   int32 status;

   // if they chose None lets return
   if (FXDevice == NumSoundCards)
      return;

   // Do special Sound Blaster, AWE32 stuff
   if (
         ( FXDevice == SoundBlaster ) ||
         ( FXDevice == Awe32 )
      )
      {
      int MaxVoices;
      int MaxBits;
      int MaxChannels;

      status = FX_SetupSoundBlaster
                  (
                  BlasterConfig, &MaxVoices, &MaxBits, &MaxChannels
                  );
      }
   else
      {
      status = FX_Ok;
      }

   if ( status == FX_Ok )
      {
      status = FX_Init( FXDevice, NumVoices, NumChannels, NumBits, MixRate );
      if ( status == FX_Ok )
         {
         FX_SetVolume( FXVolume );
         if (ReverseStereo == 1)
            {
            FX_SetReverseStereo(!FX_GetReverseStereo());
            }
         }
      }
   if ( status != FX_Ok )
      {
      Error( FX_ErrorString( FX_Error ));
      }

   status = FX_SetCallBack( TestCallBack );

   if ( status != FX_Ok )
      {
      Error( FX_ErrorString( FX_Error ));
      }

   }

/*
===================
=
= SoundShutdown
=
===================
*/

void SoundShutdown( void )
   {
   int32 status;

   // if they chose None lets return
   if (FXDevice == NumSoundCards)
      return;

   status = FX_Shutdown();
   if ( status != FX_Ok )
      {
      Error( FX_ErrorString( FX_Error ));
      }
   }

/*
===================
=
= MusicStartup
=
===================
*/

void MusicStartup( void )
   {
   int32 status;

   // if they chose None lets return
   if (MusicDevice == NumSoundCards)
      return;

   // satisfy AWE32 and WAVEBLASTER stuff
   BlasterConfig.Midi = MidiPort;

   status = MUSIC_Init( MusicDevice, MidiPort );
   if ( status == MUSIC_Ok )
      {
      MUSIC_SetVolume( MusicVolume );
      }
   else
      {
      Error( MUSIC_ErrorString( MUSIC_ErrorCode ));
      }

   }

/*
===================
=
= MusicShutdown
=
===================
*/

void MusicShutdown( void )
   {
   int32 status;

   // if they chose None lets return
   if (MusicDevice == NumSoundCards)
      return;

   status = MUSIC_Shutdown();
   if ( status != MUSIC_Ok )
      {
      Error( MUSIC_ErrorString( MUSIC_ErrorCode ));
      }
   }

int USRHOOKS_GetMem(char **ptr, unsigned long size )
{
   *ptr = (char *)malloc(size);
   if (*ptr == NULL)
      Error("Out a memory.");

   return( 0 );

}

int USRHOOKS_FreeMem(char *ptr)
{
   free(ptr);
   return( 0 );
}


