#ifndef _textlib_public_
#define _textlib_public_

//
// Defines
//

// Screen dimensions

//#define MAXTEXTHEIGHT 25
//#define MAXTEXTWIDTH  80

// Text frame defines
#define NO_FRAME     0
#define SINGLE_FRAME 1
#define DOUBLE_FRAME 2

// colors
#define COLOR_BLACK        0
#define COLOR_BLUE         1
#define COLOR_GREEN        2
#define COLOR_CYAN         3
#define COLOR_RED          4
#define COLOR_MAGENTA      5
#define COLOR_BROWN        6
#define COLOR_GRAY         7
#define COLOR_DARKGRAY     8
#define COLOR_LIGHTBLUE    9
#define COLOR_LIGHTGREEN   10
#define COLOR_LIGHTCYAN    11
#define COLOR_LIGHTRED     12
#define COLOR_LIGHTMAGENTA 13
#define COLOR_YELLOW       14
#define COLOR_WHITE        15


void StartTextMode (void);
void ShutdownTextMode (void);
void TextFrame
   (
   int32 x1,
   int32 y1,
   int32 x2,
   int32 y2,
   int32 type,
   int32 foreground,
   int32 background
   );
void TextBox
   (
   int32  x1,
   int32  y1,
   int32  x2,
   int32  y2,
   int32  ch,
   int32  foreground,
   int32  background
   );
void AttributeBox
   (
   int32  x1,
   int32  y1,
   int32  x2,
   int32  y2,
   int32  foreground,
   int32  background
   );
void DrawCharacter
   (
   int32  x,
   int32  y,
   int32  ch,
   int32  foreground,
   int32  background
   );

int32 DrawString
   (
   int32 x,
   int32 y,
   char * string,
   int32 foreground,
   int32 background
   );
void DrawBlankLine
   (
   int32 x,
   int32 y,
   int32 w,
   int32 foreground,
   int32 background
   );

void GetCharacter
   (
   int32  x,
   int32  y,
   int32 * ch,
   int32 * foreground,
   int32 * background
   );

void BlockSize
   (
   char * block,
   int32 * width,
   int32 * height
   );

boolean NextStringInBlock
   (
   char * block,
   int32 * length
   );

void SaveTextBackground ( int32 x, int32 y, int32 w, int32 h, byte * buffer );
void RestoreTextBackground ( int32 x, int32 y, int32 w, int32 h, byte * buffer );

void ToggleBlinking ( void );
void TurnOffTextCursor ( void );
void TurnOnTextCursor ( void );

extern int32 maxtextwidth;
extern int32 maxtextheight;

#endif

