#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>

#include "types.h"
#include "develop.h"
#include "scriplib.h"
#include "file_lib.h"
#include "common.h"
#include "gamedefs.h"
#include "menudefs.h"
#include "fx_man.h"
#include "menus.h"
#include "menu_lib.h"
#include "keyboard.h"
#include "util_lib.h"
#include "config.h"
#include "function.h"
#include "control.h"

#include "function.c"

//
// Sound variables
//
int32 FXDevice;
int32 MusicDevice;
int32 FXVolume;
int32 MusicVolume;
fx_blaster_config BlasterConfig;
int32 NumVoices;
int32 NumChannels;
int32 NumBits;
int32 MixRate;
int32 MidiPort;
int32 ReverseStereo;

//
// Screen variables
//
int32 ScreenMode;
int32 ScreenWidth;
int32 ScreenHeight;
int32 ScreenBufferMode;
int32 VesaBufferMode;



//
// Comm variables
//
int32 ComPort;
int32 IrqNumber;
int32 UartAddress;
int32 PortSpeed;

int32 ToneDial;
char  ModemName[MAXMODEMSTRING];
char  InitString[MAXMODEMSTRING];
char  HangupString[MAXMODEMSTRING];
char  DialoutString[MAXMODEMSTRING];
int32 SocketNumber;
char  CommbatMacro[MAXMACROS][MAXMACROLENGTH];
char  PhoneNames[MAXPHONEENTRIES][PHONENAMELENGTH];
char  PhoneNumbers[MAXPHONEENTRIES][PHONENUMBERLENGTH];
char  PhoneNumber[PHONENUMBERLENGTH];

char  PlayerName[MAXPLAYERNAMELENGTH];
char  RTSName[MAXRTSNAMELENGTH];

char  MouseButtons[MAXMOUSEBUTTONS][MAXFUNCTIONLENGTH];
char  MouseButtonsClicked[MAXMOUSEBUTTONS][MAXFUNCTIONLENGTH];

char  JoystickButtons[MAXJOYBUTTONS][MAXFUNCTIONLENGTH];
char  JoystickButtonsClicked[MAXJOYBUTTONS][MAXFUNCTIONLENGTH];

//char  ExternalButtons[MAXEXTERNALBUTTONS][MAXFUNCTIONLENGTH];
//char  ExternalButtonsClicked[MAXEXTERNALBUTTONS][MAXFUNCTIONLENGTH];

int32 ControllerType;
int32 JoystickPort;
int32 MouseSensitivity;

int32 NumberPlayers;

int32 ConnectType=0;

char setupfilename[128]={SETUPFILENAME};
static int32 scripthandle;

/*
===================
=
= GetBlasterString
=
===================
*/

#define BlasterEnv_Address    'A'
#define BlasterEnv_Interrupt  'I'
#define BlasterEnv_8bitDma    'D'
#define BlasterEnv_16bitDma   'H'
#define BlasterEnv_Type       'T'
#define BlasterEnv_Midi       'P'
#define BlasterEnv_EmuAddress 'E'

void GetBlasterString
   (
   fx_blaster_config *Config
   )

   {
   char *Blaster;
   char parameter;

   Config->Address   = 0x220;
   Config->Type      = fx_SB;
   Config->Interrupt = 5;
   Config->Dma8      = 1;
   Config->Dma16     = 5;
   Config->Midi      = 0x330;
   Config->Emu       = 0x620;

   Blaster = getenv( "BLASTER" );
   if ( Blaster == NULL )
      {
      return;
      }

   while( *Blaster != 0 )
      {
      if ( *Blaster == ' ' )
         {
         Blaster++;
         continue;
         }

      parameter = toupper( *Blaster );
      Blaster++;

      if ( !isxdigit( *Blaster ) )
         {
         return;
         }

      switch( parameter )
         {
         case BlasterEnv_Address :
            sscanf( Blaster, "%x", &Config->Address );
            break;
         case BlasterEnv_Interrupt :
            sscanf( Blaster, "%d", &Config->Interrupt );
            break;
         case BlasterEnv_8bitDma :
            sscanf( Blaster, "%d", &Config->Dma8 );
            break;
         case BlasterEnv_Type :
            sscanf( Blaster, "%d", &Config->Type );
            break;
         case BlasterEnv_16bitDma :
            sscanf( Blaster, "%d", &Config->Dma16 );
            break;
         case BlasterEnv_Midi :
            sscanf( Blaster, "%x", &Config->Midi );
            break;
         case BlasterEnv_EmuAddress :
            sscanf( Blaster, "%x", &Config->Emu );
            break;
         default  :
            // Skip the offending data
            // sscanf( Blaster, "%*s" );
            break;
         }

      while( isxdigit( *Blaster ) )
         {
         Blaster++;
         }
      }
   }
/*
===================
=
= SetDefaultKeyDefinitions
=
===================
*/
void SetDefaultKeyDefinitions( void )
   {
   int32 i;
   int32 base;
   char * functionname;
   char * keyname1;
   char * keyname2;

   for (i=0;i<NUMKEYENTRIES;i++)
      {
      base = i*3;
      functionname = keydefaults[base];
      keyname1 = keydefaults[base+1];
      keyname2 = keydefaults[base+2];
      if (*keyname1)
         {
         AddKeyFunction( functionname );
         AddKeyDef( functionname, keyname1, 0 );
         }
      if (*keyname2)
         {
         AddKeyFunction( functionname );
         AddKeyDef( functionname, keyname2, 1 );
         }
      }
   }


/*
===================
=
= SetMouseDefaults
=
===================
*/
void SetMouseDefaults( void )
   {
   int32 i;

   MouseSensitivity = 32768;
   for (i=0;i<MAXMOUSEBUTTONS;i++)
      {
      if (mousedefaults[i])
         strcpy(MouseButtons[i],mousedefaults[i]);
      if (mouseclickeddefaults[i])
         strcpy(MouseButtonsClicked[i],mouseclickeddefaults[i]);
      }
   }

/*
===================
=
= SetJoystickDefaults
=
===================
*/
void SetJoystickDefaults( void )
   {
   int32 i;

   JoystickPort = 0;
   for (i=0;i<MAXJOYBUTTONS;i++)
      {
      if (joystickdefaults[i])
         strcpy(JoystickButtons[i],joystickdefaults[i]);
      if (joystickclickeddefaults[i])
         strcpy(JoystickButtonsClicked[i],joystickclickeddefaults[i]);
      }
   }

/*
===================
=
= SetDefaults
=
===================
*/

void SetDefaults( void )
   {
#ifdef __FLAT__
   fx_blaster_config blaster;
   int32 status;

   status = FX_GetBlasterSettings( &blaster );
   if ( status == FX_Ok )
      {
      BlasterConfig.Type      = blaster.Type;
      BlasterConfig.Address   = blaster.Address;
      BlasterConfig.Interrupt = blaster.Interrupt;
      BlasterConfig.Dma8      = blaster.Dma8;
      BlasterConfig.Dma16     = blaster.Dma16;
      BlasterConfig.Midi      = blaster.Midi;
      BlasterConfig.Emu       = blaster.Emu;
      MidiPort = BlasterConfig.Midi;
      }
#else
   GetBlasterString( &BlasterConfig );
#endif

   ScreenMode = 2;
   ScreenWidth = 320;
   ScreenHeight = 200;

   FXDevice = NumSoundCards;
   MusicDevice = NumSoundCards;
   FXVolume = 205;
   MusicVolume = 255;
   ReverseStereo = 0;

   ComPort = 2;
   IrqNumber = -1;
   UartAddress = -1;
   PortSpeed = 9600;
   ToneDial = 1;
   SocketNumber = -1;
   NumberPlayers = 2;
   strcpy (InitString,"ATZ\0");
   strcpy (HangupString,"ATH0=0\0");
   DialoutString[0]='\0';
   strcpy (PlayerName,DEFAULTPLAYERNAME);
   strcpy (RTSName,DEFAULTRTSFILE);
   ControllerType = controltype_keyboardandmouse;
   SetMouseDefaults();
   SetJoystickDefaults();
   SetDefaultKeyDefinitions();
   }

/*
===================
=
= ReadSetup
=
===================
*/

void ReadSetup( void )
   {
   int32 i;
   char str[80];


   SetDefaults();
   scripthandle = SCRIPT_Load(setupfilename);

   SCRIPT_GetNumber(scripthandle, "Screen Setup","ScreenMode",&ScreenMode);
   SCRIPT_GetNumber(scripthandle, "Screen Setup","ScreenWidth",&ScreenWidth);
   SCRIPT_GetNumber(scripthandle, "Screen Setup","ScreenHeight",&ScreenHeight);

   SCRIPT_GetNumber(scripthandle, "Sound Setup", "FXDevice",&FXDevice);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "MusicDevice",&MusicDevice);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "FXVolume",&FXVolume);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "MusicVolume",&MusicVolume);

   SCRIPT_GetNumber(scripthandle, "Sound Setup", "NumVoices",&NumVoices);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "NumChannels",&NumChannels);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "NumBits",&NumBits);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "MixRate",&MixRate);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "MidiPort",&MidiPort);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "BlasterAddress",(int32 *)&BlasterConfig.Address);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "BlasterType",(int32 *)&BlasterConfig.Type);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "BlasterInterrupt",(int32 *)&BlasterConfig.Interrupt);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "BlasterDma8",(int32 *)&BlasterConfig.Dma8);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "BlasterDma16",(int32 *)&BlasterConfig.Dma16);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "BlasterEmu",(int32 *)&BlasterConfig.Emu);
   SCRIPT_GetNumber(scripthandle, "Sound Setup", "ReverseStereo",&ReverseStereo);

   SCRIPT_GetNumber(scripthandle, "Comm Setup", "ComPort",&ComPort);
   SCRIPT_GetNumber(scripthandle, "Comm Setup", "IrqNumber",&IrqNumber);
   SCRIPT_GetNumber(scripthandle, "Comm Setup", "UartAddress",&UartAddress);
   SCRIPT_GetNumber(scripthandle, "Comm Setup", "PortSpeed",&PortSpeed);
   SCRIPT_GetNumber(scripthandle, "Comm Setup", "ToneDial",&ToneDial);
   SCRIPT_GetNumber(scripthandle, "Comm Setup", "SocketNumber",&SocketNumber);
   SCRIPT_GetNumber(scripthandle, "Comm Setup", "NumberPlayers",&NumberPlayers);
   SCRIPT_GetString(scripthandle, "Comm Setup", "ModemName",ModemName);
   SCRIPT_GetString(scripthandle, "Comm Setup", "InitString",InitString);
   SCRIPT_GetString(scripthandle, "Comm Setup", "HangupString",HangupString);
   SCRIPT_GetString(scripthandle, "Comm Setup", "DialoutString",DialoutString);
   SCRIPT_GetString(scripthandle, "Comm Setup", "PlayerName",PlayerName);
   SCRIPT_GetString(scripthandle, "Comm Setup", "RTSName",RTSName);

   for (i=0;i<MAXMACROS;i++)
      {
      sprintf(str,"CommbatMacro#%ld",i);
      SCRIPT_GetString(scripthandle, "Comm Setup", str,CommbatMacro[i]);
      }

   for (i=0;i<MAXPHONEENTRIES;i++)
      {
      sprintf(str,"PhoneName#%ld",i);
      SCRIPT_GetString(scripthandle, "Comm Setup", str,PhoneNames[i]);
      sprintf(str,"PhoneNumber#%ld",i);
      SCRIPT_GetString(scripthandle, "Comm Setup", str,PhoneNumbers[i]);
      }

   SCRIPT_GetNumber(scripthandle, "Controls","ControllerType",&ControllerType);
   SCRIPT_GetNumber(scripthandle, "Controls","JoystickPort",&JoystickPort);
   SCRIPT_GetNumber(scripthandle, "Controls","MouseSensitivity",&MouseSensitivity);

   for (i=0;i<MAXMOUSEBUTTONS;i++)
      {
      // initialize to undefined
//      strcpy(MouseButtons[i],"");
//      strcpy(MouseButtonsClicked[i],"");
      sprintf(str,"MouseButton%ld",i);
      SCRIPT_GetString(scripthandle, "Controls", str,MouseButtons[i]);
      sprintf(str,"MouseButtonClicked%ld",i);
      SCRIPT_GetString(scripthandle, "Controls", str,MouseButtonsClicked[i]);
      }
   for (i=0;i<MAXJOYBUTTONS;i++)
      {
      // initialize to undefined
//      strcpy(JoystickButtons[i],"");
//      strcpy(JoystickButtonsClicked[i],"");
      sprintf(str,"JoystickButton%ld",i);
      SCRIPT_GetString(scripthandle, "Controls", str,JoystickButtons[i]);
      sprintf(str,"JoystickButtonClicked%ld",i);
      SCRIPT_GetString(scripthandle, "Controls", str,JoystickButtonsClicked[i]);
      }
/*
   for (i=0;i<MAXEXTERNALBUTTONS;i++)
      {
      // initialize to undefined
      strcpy(ExternalButtons[i],"");
      strcpy(ExternalButtonsClicked[i],"");
      sprintf(str,"ExternalButton%ld",i);
      SCRIPT_GetString(scripthandle, "Controls", str,ExternalButtons[i]);
      sprintf(str,"ExternalButtonClicked%ld",i);
      SCRIPT_GetString(scripthandle, "Controls", str,ExternalButtonsClicked[i]);
      }
*/
   InitializeKeyDefinitions(scripthandle);
   }

/*
===================
=
= WriteSetup
=
===================
*/

void WriteSetup( boolean docomments )
   {
   int32 i;
   char str[80];

   if ( !SafeFileExists ( setupfilename ) )
      {
      docomments = true;
      }

   if (docomments)
      {
      SCRIPT_PutComment(scripthandle, "Screen Setup","Setup File for " GAMENAME "");
      SCRIPT_PutMultiComment(scripthandle,"Screen Setup", "Version %s",SETUPPROGRAMVERSION);
      SCRIPT_PutEOL(scripthandle,"Screen Setup");
      SCRIPT_PutEOL(scripthandle,"Screen Setup");
      SCRIPT_PutComment(scripthandle,"Screen Setup","ScreenSetup");
      SCRIPT_PutEOL(scripthandle,"Screen Setup");
      SCRIPT_PutComment(scripthandle,"Screen Setup","ScreenMode");
      SCRIPT_PutMultiComment(scripthandle,"Screen Setup"," - Chained - %d",screenmode_chained);
      SCRIPT_PutMultiComment(scripthandle,"Screen Setup"," - Vesa 2.0 - %d",screenmode_vesa);
      SCRIPT_PutMultiComment(scripthandle,"Screen Setup"," - Screen Buffered - %d",screenmode_buffered);
      SCRIPT_PutMultiComment(scripthandle,"Screen Setup"," - Tseng optimized - %d",screenmode_tseng);
      SCRIPT_PutMultiComment(scripthandle,"Screen Setup"," - Paradise optimized - %d",screenmode_paradise);
      SCRIPT_PutMultiComment(scripthandle,"Screen Setup"," - S3 optimized - %d",screenmode_s3);
      SCRIPT_PutMultiComment(scripthandle,"Screen Setup"," - RedBlue Stereo - %d",screenmode_redblue);
      SCRIPT_PutMultiComment(scripthandle,"Screen Setup"," - Crystal Eyes - %d",screenmode_crystal);
      SCRIPT_PutEOL(scripthandle,"Screen Setup");
      SCRIPT_PutComment(scripthandle,"Screen Setup","ScreenWidth passed to engine");
      SCRIPT_PutEOL(scripthandle,"Screen Setup");
      SCRIPT_PutComment(scripthandle,"Screen Setup","ScreenHeight passed to engine");
      SCRIPT_PutEOL(scripthandle,"Screen Setup");
      SCRIPT_PutEOL(scripthandle,"Screen Setup");
      }

//   PutScriptSectionHeader( "Screen Setup");
   SCRIPT_PutNumber(scripthandle, "Screen Setup","ScreenMode",ScreenMode,false,false);
   SCRIPT_PutNumber(scripthandle, "Screen Setup","ScreenWidth",ScreenWidth,false,false);
   SCRIPT_PutNumber(scripthandle, "Screen Setup","ScreenHeight",ScreenHeight,false,false);

   if (docomments)
      {
      SCRIPT_PutEOL(scripthandle,"Screen Setup");
      SCRIPT_PutEOL(scripthandle,"Screen Setup");
      }

//   PutScriptSectionHeader( "Sound Setup");
   SCRIPT_PutNumber(scripthandle, "Sound Setup","FXDevice",FXDevice,false,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","MusicDevice",MusicDevice,false,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","FXVolume",FXVolume,false,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","MusicVolume",MusicVolume,false,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","NumVoices",NumVoices,false,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","NumChannels",NumChannels,false,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","NumBits",NumBits,false,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","MixRate",MixRate,false,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","MidiPort",MidiPort,true,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","BlasterAddress",BlasterConfig.Address,true,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","BlasterType",BlasterConfig.Type,false,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","BlasterInterrupt",BlasterConfig.Interrupt,false,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","BlasterDma8",BlasterConfig.Dma8,false,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","BlasterDma16",BlasterConfig.Dma16,false,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","BlasterEmu",BlasterConfig.Emu,true,false);
   SCRIPT_PutNumber(scripthandle, "Sound Setup","ReverseStereo",ReverseStereo,false,false);

   if (docomments)
      {
      SCRIPT_PutEOL(scripthandle,"Sound Setup");
      SCRIPT_PutEOL(scripthandle,"Sound Setup");
      }

   WriteKeyDefinitions(scripthandle);

   if (docomments)
      {
      SCRIPT_PutEOL(scripthandle,"Controls");
      SCRIPT_PutEOL(scripthandle,"Controls");
      SCRIPT_PutComment(scripthandle,"Controls","Controls");
      SCRIPT_PutEOL(scripthandle,"Controls");
      SCRIPT_PutComment(scripthandle,"Controls","ControllerType");
      SCRIPT_PutMultiComment(scripthandle,"Controls"," - Keyboard - %d",controltype_keyboard);
      SCRIPT_PutMultiComment(scripthandle,"Controls"," - Keyboard and Mouse - %d",controltype_keyboardandmouse);
      SCRIPT_PutMultiComment(scripthandle,"Controls"," - Keyboard and Joystick - %d",controltype_keyboardandjoystick);
      SCRIPT_PutMultiComment(scripthandle,"Controls"," - Keyboard and Gamepad - %d",controltype_keyboardandgamepad);
      SCRIPT_PutMultiComment(scripthandle,"Controls"," - Keyboard and External - %d",controltype_keyboardandexternal);
      SCRIPT_PutEOL(scripthandle,"Controls");
      SCRIPT_PutEOL(scripthandle,"Controls");
      }
//   PutScriptSectionHeader( "Controls");
   SCRIPT_PutNumber(scripthandle, "Controls","ControllerType",ControllerType,false,false);
   SCRIPT_PutNumber(scripthandle, "Controls","JoystickPort",JoystickPort,false,false);
   SCRIPT_PutNumber(scripthandle, "Controls","MouseSensitivity",MouseSensitivity,false,false);

   for (i=0;i<MAXMOUSEBUTTONS;i++)
       {
       sprintf(str,"MouseButton%ld",i);
       SCRIPT_PutString(scripthandle, "Controls",str,MouseButtons[i] );
       sprintf(str,"MouseButtonClicked%ld",i);
       SCRIPT_PutString(scripthandle, "Controls",str,MouseButtonsClicked[i] );
       }
   for (i=0;i<MAXJOYBUTTONS;i++)
       {
       sprintf(str,"JoystickButton%ld",i);
       SCRIPT_PutString(scripthandle, "Controls",str,JoystickButtons[i] );
       sprintf(str,"JoystickButtonClicked%ld",i);
       SCRIPT_PutString(scripthandle, "Controls",str,JoystickButtonsClicked[i] );
       }
/*
   for (i=0;i<MAXEXTERNALBUTTONS;i++)
       {
       sprintf(str,"ExternalButton%ld",i);
       SCRIPT_PutString(scripthandle, "Controls",str,ExternalButtons[i] );
       sprintf(str,"ExternalButtonClicked%ld",i);
       SCRIPT_PutString(scripthandle, "Controls",str,ExternalButtonsClicked[i] );
       }
*/

   if (docomments)
      {
      SCRIPT_PutEOL(scripthandle,"Comm Setup");
      SCRIPT_PutEOL(scripthandle,"Comm Setup");
      }
//   PutScriptSectionHeader( "Comm Setup");
   SCRIPT_PutNumber(scripthandle, "Comm Setup","ComPort",ComPort,false,false);
   SCRIPT_PutNumber(scripthandle, "Comm Setup","IrqNumber",IrqNumber,false,(IrqNumber == -1));
   SCRIPT_PutNumber(scripthandle, "Comm Setup","UartAddress",UartAddress,true,(UartAddress == -1));
   SCRIPT_PutNumber(scripthandle, "Comm Setup","PortSpeed",PortSpeed,false,false);
   SCRIPT_PutNumber(scripthandle, "Comm Setup","ToneDial",ToneDial,false,false);
   SCRIPT_PutNumber(scripthandle, "Comm Setup","SocketNumber",SocketNumber,true,(SocketNumber == -1));
   SCRIPT_PutNumber(scripthandle, "Comm Setup","NumberPlayers",NumberPlayers,false,false);
   SCRIPT_PutString(scripthandle, "Comm Setup","ModemName",ModemName);
   SCRIPT_PutString(scripthandle, "Comm Setup","InitString",InitString);
   SCRIPT_PutString(scripthandle, "Comm Setup","HangupString",HangupString);
   SCRIPT_PutString(scripthandle, "Comm Setup","DialoutString",DialoutString);
   SCRIPT_PutString(scripthandle, "Comm Setup","PlayerName",PlayerName);
   SCRIPT_PutString(scripthandle, "Comm Setup","RTSName",RTSName);

   for (i=0;i<MAXMACROS;i++)
      {
      sprintf(str,"CommbatMacro#%ld",i);
      SCRIPT_PutString(scripthandle, "Comm Setup",str,CommbatMacro[i]);
      }

   for (i=0;i<MAXPHONEENTRIES;i++)
      {
      sprintf(str,"PhoneName#%ld",i);
      SCRIPT_PutString(scripthandle, "Comm Setup",str,PhoneNames[i]);
      sprintf(str,"PhoneNumber#%ld",i);
      SCRIPT_PutString(scripthandle, "Comm Setup",str,PhoneNumbers[i]);
      }

   SCRIPT_Save(scripthandle, setupfilename);
   SCRIPT_Free(scripthandle);
   }

/*
===================
=
= WriteCommitFile
=
===================
*/

void WriteCommitFile( int32 gametype )
   {
   char str[80];
   int32 handle;

   handle = SCRIPT_Init(COMMITFILENAME);

   SCRIPT_PutComment(handle,"Commit", "COMMIT data file");
   SCRIPT_PutEOL(handle,"Commit");
   SCRIPT_PutComment(handle,"Commit","This data file defines the configurable options of COMMIT.  Presumably,");
   SCRIPT_PutComment(handle,"Commit","the user never sees this file, but rather it is setup by another");
   SCRIPT_PutComment(handle,"Commit","program which launches COMMIT.");
   SCRIPT_PutEOL(handle,"Commit");
   SCRIPT_PutEOL(handle,"Commit");
   SCRIPT_PutComment(handle,"Commit","COMMTYPE");
   SCRIPT_PutMultiComment(handle,"Commit"," - SERIAL - %d",gametype_serial);
   SCRIPT_PutMultiComment(handle,"Commit"," - MODEM - %d",gametype_modem);
   SCRIPT_PutMultiComment(handle,"Commit"," - NETWORK - %d",gametype_network);
   SCRIPT_PutEOL(handle,"Commit");
   SCRIPT_PutComment(handle,"Commit"," NUMPLAYERS");
   SCRIPT_PutComment(handle,"Commit"," - 0..MAXPLAYERS");
   SCRIPT_PutEOL(handle,"Commit");
   SCRIPT_PutComment(handle,"Commit"," VECTOR");
   SCRIPT_PutComment(handle,"Commit"," - ~ find an empty one");
   SCRIPT_PutComment(handle,"Commit"," - 0x60..0x69 specify one");
   SCRIPT_PutEOL(handle,"Commit");
   SCRIPT_PutComment(handle,"Commit"," CONNECTTYPE");
   SCRIPT_PutMultiComment(handle,"Commit"," - DIALMODE - %d",connecttype_dialing);
   SCRIPT_PutMultiComment(handle,"Commit"," - ANSWERMODE - %d",connecttype_answer);
   SCRIPT_PutMultiComment(handle,"Commit"," - ALREADYCONNECTED - %d",connecttype_alreadyconnected);
   SCRIPT_PutEOL(handle,"Commit");

//   PutScriptSectionHeader( "Commit");
   SCRIPT_PutNumber( handle,"Commit","COMMTYPE",gametype,false,false);
   switch (gametype)
      {
      case gametype_network:
         SCRIPT_PutNumber( handle,"Commit","NUMPLAYERS",NumberPlayers,false,false);
         break;
      case gametype_serial:
      case gametype_modem:
         SCRIPT_PutNumber( handle,"Commit","NUMPLAYERS",2,false,false);
         break;
      }
   SCRIPT_PutNumber( handle,"Commit","PAUSE",0,false,false);
   SCRIPT_PutNumber( handle,"Commit","VECTOR",0,false,true);
   if (SocketNumber == -1)
      SCRIPT_PutNumber( handle,"Commit","SOCKETNUMBER",DEFAULTSOCKETNUMBER,false,false);
   else
      SCRIPT_PutNumber( handle,"Commit","SOCKETNUMBER",SocketNumber,false,false);
   SCRIPT_PutString( handle,"Commit","INITSTRING",InitString);
   SCRIPT_PutString( handle,"Commit","HANGUPSTRING",HangupString);
   sprintf(str,"%s%s",DialoutString,PhoneNumber);
   SCRIPT_PutString( handle,"Commit","PHONENUMBER",str);
   SCRIPT_PutString( handle,"Commit","LAUNCHNAME",GAMELAUNCHER);
   SCRIPT_PutNumber( handle,"Commit","CONNECTTYPE",ConnectType,false,false);
   SCRIPT_PutNumber( handle,"Commit","USETONE",ToneDial,false,false);
   SCRIPT_PutNumber( handle,"Commit","COMPORT",ComPort,false,false);
   SCRIPT_PutNumber( handle,"Commit","IRQNUMBER",IrqNumber,false,(IrqNumber == -1));
   SCRIPT_PutNumber( handle,"Commit","UARTADDRESS",UartAddress,true,(UartAddress == -1));
   SCRIPT_PutNumber( handle,"Commit","PORTSPEED",PortSpeed,false,false);
   SCRIPT_PutNumber( handle,"Commit","SHOWSTATS",0,false,false);

   SCRIPT_Save( handle, COMMITFILENAME );
   SCRIPT_Free( handle );
   }


/*
===================
=
= GetSetupFilename
=
===================
*/
#define MAXSETUPFILES 20
void GetSetupFilename( void )
   {
   struct find_t fblock;
   char extension[10];
   char * src;
   char * filenames[MAXSETUPFILES];
   int32 numfiles;
   int32 i;

   strcpy(setupfilename,SETUPFILENAME);

   // determine extension

   src = setupfilename + strlen(setupfilename) - 1;

   while (*src != '.')
      {
      src--;
      }
   strcpy (&extension[1],src);
   extension[0] = '*';

   numfiles=0;
   if (_dos_findfirst(extension,0,&fblock)==0)
      {
      do
         {
         filenames[numfiles]=SafeMalloc(128);
         strcpy(filenames[numfiles],fblock.name);
         numfiles++;
         if (numfiles == MAXSETUPFILES)
            break;
        }
      while(!_dos_findnext(&fblock));
      }
   i = CheckParm (SETUPNAMEPARM);
   if (i!=0)
      {
      numfiles = 0;
      strcpy(setupfilename,_argv[i+1]);
      }
   if (numfiles>1)
      {
      int32 time;
      int32 oldtime;
      int32 count;

      printf("\nMultiple Configuration Files Encountered\n");
      printf("========================================\n\n");
      printf("Please choose a configuration file from\n");
      printf("the following list by pressing it's\n");
      printf("corresponding letter:\n\n");
      printf("The default file will be used if no selection\n");
      printf("is made within 10 seconds.\n\n");
      for (i=0;i<numfiles;i++)
         {
         if (strcmpi(filenames[i],SETUPFILENAME))
            printf("%c. %s\n",'a'+i,filenames[i]);
         else
            printf("%c. %s <DEFAULT>\n",'a'+i,filenames[i]);
         }
      printf("\n");
      KB_FlushKeyboardQueue();
      KB_ClearKeysDown();
      count = 9;
      oldtime = clock();
      time=clock()+(10*CLOCKS_PER_SEC);
      while (clock()<time)
         {
         if (clock()>oldtime)
            {
            printf("%ld seconds left. \r",count);
            fflush(stdout);
            oldtime = clock()+CLOCKS_PER_SEC;
            count--;
            }
         if (KB_KeyWaiting())
            {
            int32 ch = KB_Getch();
            ch -='a';
            if (ch>=0 && ch<numfiles)
               {
               strcpy (setupfilename, filenames[ch]);
               break;
               }
            }
         }
      printf("\n");
      }
   printf("Using Setup file: %s\n",setupfilename);
   i=clock()+(3*CLOCKS_PER_SEC/4);
   while (clock()<i)
      {
      ;
      }
   for (i=0;i<numfiles;i++)
      {
      SafeFree(filenames[i]);
      }
   }

