//****************************************************************************
//
// cntrlmnu.h
//
// control menu definitions
//
//****************************************************************************

#ifndef _controlmenu_private_definitions_
#define _controlmenu_private_definitions_

// =========================================================================
// ControllerChoice Menu
// ControllerChoice Menu Section 1
MenuSectionType ControllerChoiceMenuSection1 =
   {
   //|_NUM|_CE_| Section Type
         5,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "Keyboard Only\0", // text
         "Use only the keyboard to play " GAMENAME "\0", // help
         &ControllerType, // ptr
         controltype_keyboard
         },

         {
         status_active,
         entrytype_choice,
         "Keyboard and Mouse\0", // text
         "Use the keyboard and mouse to play " GAMENAME "\0", // help
         &ControllerType, // ptr
         controltype_keyboardandmouse
         },

         {
         status_active,
         entrytype_choice,
         "Keyboard and Joystick\0", // text
         "Use the keyboard and joystick to play " GAMENAME "\0", // help
         &ControllerType, // ptr
         controltype_keyboardandjoystick
         },

         {
         status_active,
         entrytype_choice,
         "Keyboard and Gamepad\0", // text
         "Use the keyboard and gamepad to play " GAMENAME "\0", // help
         &ControllerType, // ptr
         controltype_keyboardandgamepad
         },

         {
         status_active,
         entrytype_choice,
         "Keyboard and External\0", // text
         "Use the keyboard and an External Control API to play " GAMENAME "\0", // help
         &ControllerType, // ptr
         controltype_keyboardandexternal
         },
      }
   };

MenuType ControllerChoiceMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Choose a Controller Combination\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &ControllerChoiceMenuSection1
      }
   };

// =========================================================================
// SetupMouse Menu
// SetupMouse Menu Section 1
MenuSectionType SetupMouseSection1 =
   {
   //|_NUM|_CE_| Section Type
         3,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "Single Clicked Mouse Buttons\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_fromfunctions,
         "Left Button\0", // text
         "Assign a function to the left mouse button\0", // help
         MouseButtons[0],
         },


         {
         status_active,
         entrytype_fromfunctions,
         "Middle Button\0", // text
         "Assign a function to the middle mouse button\0", // help
         MouseButtons[2],
         },

         {
         status_active,
         entrytype_fromfunctions,
         "Right Button\0", // text
         "Assign a function to the right mouse button\0", // help
         MouseButtons[1],
         },
      }
   };

// SetupMouse Menu Section 2
MenuSectionType SetupMouseSection2 =
   {
   //|_NUM|_CE_| Section Type
         3,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "Double Clicked Mouse Buttons\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_fromfunctions,
         "Left Button\0", // text
         "Assign a function to the left mouse button double clicked\0", // help
         MouseButtonsClicked[0],
         },
         {
         status_active,
         entrytype_fromfunctions,
         "Middle Button\0", // text
         "Assign a function to the middle mouse button double clicked\0", // help
         MouseButtonsClicked[2],
         },
         {
         status_active,
         entrytype_fromfunctions,
         "Right Button\0", // text
         "Assign a function to the right mouse button double clicked\0", // help
         MouseButtonsClicked[1],
         },
      }
   };

// SetupMouse Menu Section 3
MenuSectionType SetupMouseSection3 =
   {
   //|_NUM|_CE_| Section Type
         1,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "Mouse Sensitivity\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_entervalue,
         "Adjust Mouse Sensitivity\0", // text
         "Change Mouse Sensitivity (the responsiveness of the mouse)\0", // help
         &MouseSensitivity, // ptr
         valuetype_slider,
         0,
         65535
         },
      }
   };

MenuType SetupMouseMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         3,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Setup Mouse\0",
   // Window Footer
      "Esc Exits  Del Deletes   Selects\0",
   //
   // menu body
   //
      {
      &SetupMouseSection1,
      &SetupMouseSection2,
      &SetupMouseSection3
      }
   };

// =========================================================================
// SetupJoystick Menu
// SetupJoystick Menu Section 1
MenuSectionType SetupJoystickSection1 =
   {
   //|_NUM|_CE_| Section Type
         4,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "Single Clicked Joystick Buttons\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_fromfunctions,
         "Button 1\0", // text
         "Assign a function to Joystick button 1\0", // help
         JoystickButtons[0],
         },

         {
         status_active,
         entrytype_fromfunctions,
         "Button 2\0", // text
         "Assign a function to Joystick button 2\0", // help
         JoystickButtons[1],
         },

         {
         status_active,
         entrytype_fromfunctions,
         "Button 3\0", // text
         "Assign a function to Joystick button 3\0", // help
         JoystickButtons[2],
         },

         {
         status_active,
         entrytype_fromfunctions,
         "Button 4\0", // text
         "Assign a function to Joystick button 4\0", // help
         JoystickButtons[3],
         },
      }
   };

// SetupJoystick Menu Section 2
MenuSectionType SetupJoystickSection2 =
   {
   //|_NUM|_CE_| Section Type
         4,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "Double Clicked Joystick Buttons\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_fromfunctions,
         "Button 1\0", // text
         "Assign a function to Joystick button 1 Double Clicked\0", // help
         JoystickButtonsClicked[0],
         },
         {
         status_active,
         entrytype_fromfunctions,
         "Button 2\0", // text
         "Assign a function to Joystick button 2 Double Clicked\0", // help
         JoystickButtonsClicked[1],
         },
         {
         status_active,
         entrytype_fromfunctions,
         "Button 3\0", // text
         "Assign a function to Joystick button 3 Double Clicked\0", // help
         JoystickButtonsClicked[2],
         },
         {
         status_active,
         entrytype_fromfunctions,
         "Button 4\0", // text
         "Assign a function to Joystick button 4 Double Clicked\0", // help
         JoystickButtonsClicked[3],
         },
      }
   };

// SetupJoystick Menu Section 3
MenuSectionType SetupJoystickSection3 =
   {
   //|_NUM|_CE_| Section Type
         2,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "Joystick Port\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_value,
         "Use Joystick Port 1\0", // text
         "Use Joystick port 1, the most common port.\0", // help
         &JoystickPort, // ptr
         0,
         },
         {
         status_active,
         entrytype_value,
         "Use Joystick Port 2\0", // text
         "Use Joystick port 2, for machines with two joysticks connected.\0", // help
         &JoystickPort, // ptr
         1,
         },
      }
   };


MenuType SetupJoystickMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         3,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Setup Joystick\0",
   // Window Footer
      "Esc Exits  Del Deletes   Selects\0",
   //
   // menu body
   //
      {
      &SetupJoystickSection1,
      &SetupJoystickSection2,
      &SetupJoystickSection3
      }
   };
/*

// =========================================================================
// SetupExternal Menu
// SetupExternal Menu Section 1
MenuSectionType SetupExternalSection1 =
   {
   //|_NUM|_CE_| Section Type
         MAXEXTERNALBUTTONS,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "Single Clicked External Buttons\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_fromfunctions,
         "Button 1\0", // text
         "Assign a function to External button 1\0", // help
         ExternalButtons[0],
         },

         {
         status_active,
         entrytype_fromfunctions,
         "Button 2\0", // text
         "Assign a function to External button 2\0", // help
         ExternalButtons[1],
         },

         {
         status_active,
         entrytype_fromfunctions,
         "Button 3\0", // text
         "Assign a function to External button 3\0", // help
         ExternalButtons[2],
         },

         {
         status_active,
         entrytype_fromfunctions,
         "Button 4\0", // text
         "Assign a function to External button 4\0", // help
         ExternalButtons[3],
         },

         {
         status_active,
         entrytype_fromfunctions,
         "Button 5\0", // text
         "Assign a function to External button 5\0", // help
         ExternalButtons[4],
         },

         {
         status_active,
         entrytype_fromfunctions,
         "Button 6\0", // text
         "Assign a function to External button 6\0", // help
         ExternalButtons[5],
         },
*/

/*
         {
         status_active,
         entrytype_fromfunctions,
         "Button 7\0", // text
         "Assign a function to External button 7\0", // help
         ExternalButtons[6],
         },

         {
         status_active,
         entrytype_fromfunctions,
         "Button 8\0", // text
         "Assign a function to External button 8\0", // help
         ExternalButtons[7],
         },
*/
/*
      }
   };

// SetupJoystick Menu Section 2
MenuSectionType SetupExternalSection2 =
   {
   //|_NUM|_CE_| Section Type
         MAXEXTERNALBUTTONS,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "Double Clicked External Buttons\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_fromfunctions,
         "Button 1\0", // text
         "Assign a function to External button 1 Double Clicked\0", // help
         ExternalButtonsClicked[0],
         },
         {
         status_active,
         entrytype_fromfunctions,
         "Button 2\0", // text
         "Assign a function to External button 2 Double Clicked\0", // help
         ExternalButtonsClicked[1],
         },
         {
         status_active,
         entrytype_fromfunctions,
         "Button 3\0", // text
         "Assign a function to External button 3 Double Clicked\0", // help
         ExternalButtonsClicked[2],
         },
         {
         status_active,
         entrytype_fromfunctions,
         "Button 4\0", // text
         "Assign a function to External button 4 Double Clicked\0", // help
         ExternalButtonsClicked[3],
         },
         {
         status_active,
         entrytype_fromfunctions,
         "Button 5\0", // text
         "Assign a function to External button 5 Double Clicked\0", // help
         ExternalButtonsClicked[4],
         },
         {
         status_active,
         entrytype_fromfunctions,
         "Button 6\0", // text
         "Assign a function to External button 6 Double Clicked\0", // help
         ExternalButtonsClicked[5],
         },
*/
/*
         {
         status_active,
         entrytype_fromfunctions,
         "Button 7\0", // text
         "Assign a function to External button 7 Double Clicked\0", // help
         ExternalButtonsClicked[6],
         },
         {
         status_active,
         entrytype_fromfunctions,
         "Button 8\0", // text
         "Assign a function to External button 8 Double Clicked\0", // help
         ExternalButtonsClicked[7],
         },
*/
/*
      }
   };


MenuType SetupExternalMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         2,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Setup External\0",
   // Window Footer
      "Esc Exits  Del Deletes   Selects\0",
   //
   // menu body
   //
      {
      &SetupExternalSection1,
      &SetupExternalSection2,
      }
   };
*/

// =========================================================================
// Control Menu
// Control Menu Section 1
MenuSectionType ControlMenuSection1 =
   {
   //|_NUM|_CE_| Section Type
         1,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_display,
         entrytype_translatevalue,
         "Current Controller Type\0", // text
         "\0", // help
         &ControllerTypeName, // ptr
         &ControllerType, // ptr
         },

      }
   };

// Control Menu Section 2
MenuSectionType ControlMenuSection2 =
   {
   //|_NUM|_CE_| Section Type
         4,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_menulink,
         "Choose Controller Type\0", // text
         "Choose which controllers you would like to use in " GAMENAME "\0", // help
         &ControllerChoiceMenu, // ptr
         },

         {
         status_active,
         entrytype_functionlink,
         "Setup Keyboard\0", // text
         "Setup keyboard definitions for " GAMENAME "\0", // help
         &DoKeyDefs,
         },

         {
         status_active,
         entrytype_menulink,
         "Setup Mouse\0", // text
         "Setup Mouse button definitions for " GAMENAME "\0", // help
         &SetupMouseMenu, // ptr
         },
         {
         status_active,
         entrytype_menulink,
         "Setup Joystick\0", // text
         "Setup Joystick button definitions for " GAMENAME "\0", // help
         &SetupJoystickMenu,
         },
/*
         {
         status_active,
         entrytype_menulink,
         "Setup External\0", // text
         "Setup External button definitions for " GAMENAME "\0", // help
         &SetupExternalMenu,
         },
*/

      }
   };

MenuType ControlMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         2,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Controls Menu\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &ControlMenuSection1,
      &ControlMenuSection2
      }
   };


#endif
