// vid.h -- video driver defs
#ifndef __vid_h
#define __vid_h

typedef enum {disp_bitmap, disp_framebuffer}	display_t;

typedef void pixel_t;
// a pixel can be one, two, or four bytes

typedef byte pixel;

typedef struct
   {
	int x;
	int y;
	int width;
	int height;
	} vrect_t;

typedef struct
   {
	pixel_t		*buffer;
	pixel_t		*colormap;	// 256*pixbytes*grades size
	unsigned	pixbytes;  		// 1, 2, or 4
	unsigned	rowbytes;		// may be > width*pixbytes if displayed in a window
	unsigned	width;		
	unsigned	height;
	float		aspect;			// width / height -- < 0 is taller than wide
	unsigned	cbits;
	unsigned	grades;			// 1<<cbits for convenience
   } viddef_t;

extern	viddef_t	vid;		// global video state

void VID_NormalizePalette (byte *palette);
// Changes a 0-255 rgb palette to a 0-63 rgb palette compatible with VGA

void	VID_SetPalette (byte *palette);
// called at startup and after any gamma correction

void	VID_GetPalette (byte *palette);
// called at startup and after any gamma correction

void	VID_Init (byte *palette, display_t displaytype, int scale );
// Called at startup to set up translation tables, takes 256 8 bit RGB values
// the palette data will go away after the call, so it must be copied off if
// the video driver will need it again

void	VID_Shutdown (void);
// Called at shutdown

void VID_GetBuffer (void);
// Called each frame before any drawing is to take place
// changes vid for next frame

void	VID_Update (int rectcount, vrect_t *rects);
// flushes the given rectangles from the view buffer to the screen

void  VID_UpdateScreen( void );
// flushes the entire view buffer to the screen

void  VID_ClearViewBuffer( int color );
// Sets the view buffer to a single color.

void ServiceEvents( void );
// Services any pending events (mouse, keyboard, window, etc.)
// Required for any events to take place.

#endif /* __vid_h */
