#ifndef _wndolib_private_
#define _wndolib_private_

//
// Defines
//

#define MAXWINDOWS 10
#define WINDOWBORDERSIZE 1
#define WINDOWDROPSHADOWSIZEX 2
#define WINDOWDROPSHADOWSIZEY 1

//
// Typedefs
//

typedef struct
{
   boolean inuse;
   int16 x;
   int16 y;
   int16 width;
   int16 height;
   int16 foreground;
   int16 background;
   byte * saved_background;
} TextWindowType;

//
// Functions
//

void CheckWindowHandle ( int32 windowhandle );
void FreeUpWindow( int32 windowhandle );
int32 GetWindow( void );
void SaveWindowBackground( int32 windowhandle );
void RestoreWindowBackground( int32 windowhandle );

#endif
