//****************************************************************************
//
// scn_menu.h
//
// screen modes menu definitions
//
//****************************************************************************

#ifndef _scn_menu_definitions_
#define _scn_menu_definitions_

// =========================================================================

MenuSectionType ScreenWidthSetupSection1 =
   {
   //|_NUM|_CE_| Section Type
         4,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "256 pixels\0", // text
         "Set screen width to 256 pixels\0", // help
         &ScreenWidth, // ptr
         256,
         },

         {
         status_active,
         entrytype_choice,
         "320 pixels\0", // text
         "Set screen width to 320 pixels\0", // help
         &ScreenWidth, // ptr
         320,
         },

         {
         status_active,
         entrytype_choice,
         "360 pixels\0", // text
         "Set screen width to 360 pixels\0", // help
         &ScreenWidth, // ptr
         360,
         },
         {
         status_active,
         entrytype_choice,
         "400 pixels\0", // text
         "Set screen width to 400 pixels\0", // help
         &ScreenWidth, // ptr
         400,
         },
      }
   };

MenuType ScreenWidthSetupMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Choose a Screen Width\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &ScreenWidthSetupSection1
      }
   };

// =========================================================================

MenuSectionType ScreenHeightSetupSection1 =
   {
   //|_NUM|_CE_| Section Type
         11,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "200 pixels\0", // text
         "Set screen height to 200 pixels\0", // help
         &ScreenHeight, // ptr
         200,
         },

         {
         status_active,
         entrytype_choice,
         "240 pixels\0", // text
         "Set screen height to 240 pixels\0", // help
         &ScreenHeight, // ptr
         240,
         },

         {
         status_active,
         entrytype_choice,
         "256 pixels\0", // text
         "Set screen height to 256 pixels\0", // help
         &ScreenHeight, // ptr
         256,
         },

         {
         status_active,
         entrytype_choice,
         "270 pixels\0", // text
         "Set screen height to 270 pixels\0", // help
         &ScreenHeight, // ptr
         270,
         },

         {
         status_active,
         entrytype_choice,
         "300 pixels\0", // text
         "Set screen height to 300 pixels\0", // help
         &ScreenHeight, // ptr
         300,
         },

         {
         status_active,
         entrytype_choice,
         "350 pixels\0", // text
         "Set screen height to 350 pixels\0", // help
         &ScreenHeight, // ptr
         350,
         },

         {
         status_active,
         entrytype_choice,
         "360 pixels\0", // text
         "Set screen height to 360 pixels\0", // help
         &ScreenHeight, // ptr
         360,
         },

         {
         status_active,
         entrytype_choice,
         "400 pixels\0", // text
         "Set screen height to 400 pixels\0", // help
         &ScreenHeight, // ptr
         400,
         },

         {
         status_active,
         entrytype_choice,
         "480 pixels\0", // text
         "Set screen height to 480 pixels\0", // help
         &ScreenHeight, // ptr
         480,
         },

         {
         status_active,
         entrytype_choice,
         "512 pixels\0", // text
         "Set screen height to 512 pixels\0", // help
         &ScreenHeight, // ptr
         512,
         },

         {
         status_active,
         entrytype_choice,
         "540 pixels\0", // text
         "Set screen height to 540 pixels\0", // help
         &ScreenHeight, // ptr
         540,
         },
      }
   };

MenuType ScreenHeightSetupMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Choose a Screen Height\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &ScreenHeightSetupSection1
      }
   };


// =========================================================================

MenuSectionType ScreenBufferSetupSection1 =
   {
   //|_NUM|_CE_| Section Type
         7,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "320 x 200\0", // text
         "Set screen width to 320 pixels and screen height to 200 pixels\0", // help
         &ScreenBufferMode, // ptr
         screenbuffer_320x200,
         },

         {
         status_active,
         entrytype_choice,
         "640 x 400\0", // text
         "Set screen width to 640 pixels and screen height to 400 pixels\0", // help
         &ScreenBufferMode, // ptr
         screenbuffer_640x400,
         },
         {
         status_active,
         entrytype_choice,
         "640 x 480\0", // text
         "Set screen width to 640 pixels and screen height to 480 pixels\0", // help
         &ScreenBufferMode, // ptr
         screenbuffer_640x480,
         },
         {
         status_active,
         entrytype_choice,
         "800 x 600\0", // text
         "Set screen width to 800 pixels and screen height to 600 pixels\0", // help
         &ScreenBufferMode, // ptr
         screenbuffer_800x600,
         },
         {
         status_active,
         entrytype_choice,
         "1024 x 768\0", // text
         "Set screen width to 1024 pixels and screen height to 768 pixels\0", // help
         &ScreenBufferMode, // ptr
         screenbuffer_1024x768,
         },
         {
         status_active,
         entrytype_choice,
         "1280 x 1024\0", // text
         "Set screen width to 1280 pixels and screen height to 1024 pixels\0", // help
         &ScreenBufferMode, // ptr
         screenbuffer_1280x1024,
         },
         {
         status_active,
         entrytype_choice,
         "1600 x 1200\0", // text
         "Set screen width to 1600 pixels and screen height to 1200 pixels\0", // help
         &ScreenBufferMode, // ptr
         screenbuffer_1600x1200,
         },
      }
   };

MenuType ScreenBufferSetupMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Choose a Screen Buffer Mode\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &ScreenBufferSetupSection1
      }
   };

// =========================================================================

MenuSectionType VesaSetupSection1 =
   {
   //|_NUM|_CE_| Section Type
         12,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "320 x 200\0", // text
         "Set screen width to 320 pixels and screen height to 200 pixels\0", // help
         &VesaBufferMode, // ptr
         vesa_320x200,
         },

         {
         status_active,
         entrytype_choice,
         "360 x 200\0", // text
         "Set screen width to 360 pixels and screen height to 200 pixels\0", // help
         &VesaBufferMode, // ptr
         vesa_360x200,
         },

         {
         status_active,
         entrytype_choice,
         "320 x 240\0", // text
         "Set screen width to 320 pixels and screen height to 240 pixels\0", // help
         &VesaBufferMode, // ptr
         vesa_320x240,
         },
         {
         status_active,
         entrytype_choice,
         "360 x 240\0", // text
         "Set screen width to 360 pixels and screen height to 240 pixels\0", // help
         &VesaBufferMode, // ptr
         vesa_360x240,
         },
         {
         status_active,
         entrytype_choice,
         "360 x 400\0", // text
         "Set screen width to 360 pixels and screen height to 400 pixels\0", // help
         &VesaBufferMode, // ptr
         vesa_360x400,
         },
         {
         status_active,
         entrytype_choice,
         "640 x 350\0", // text
         "Set screen width to 640 pixels and screen height to 350 pixels\0", // help
         &VesaBufferMode, // ptr
         vesa_640x350,
         },
         {
         status_active,
         entrytype_choice,
         "640 x 400\0", // text
         "Set screen width to 640 pixels and screen height to 400 pixels\0", // help
         &VesaBufferMode, // ptr
         vesa_640x400,
         },
         {
         status_active,
         entrytype_choice,
         "640 x 480\0", // text
         "Set screen width to 640 pixels and screen height to 480 pixels\0", // help
         &VesaBufferMode, // ptr
         vesa_640x480,
         },
         {
         status_active,
         entrytype_choice,
         "800 x 600\0", // text
         "Set screen width to 800 pixels and screen height to 600 pixels\0", // help
         &VesaBufferMode, // ptr
         vesa_800x600,
         },
         {
         status_active,
         entrytype_choice,
         "1024 x 768\0", // text
         "Set screen width to 1024 pixels and screen height to 768 pixels\0", // help
         &VesaBufferMode, // ptr
         vesa_1024x768,
         },
         {
         status_active,
         entrytype_choice,
         "1280 x 1024\0", // text
         "Set screen width to 1280 pixels and screen height to 1024 pixels\0", // help
         &VesaBufferMode, // ptr
         vesa_1280x1024,
         },
         {
         status_active,
         entrytype_choice,
         "1600 x 1200\0", // text
         "Set screen width to 1600 pixels and screen height to 1200 pixels\0", // help
         &VesaBufferMode, // ptr
         vesa_1600x1200,
         },
      }
   };

MenuType VesaSetupMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         1,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Choose a Vesa 2.0 Linear Graphics Mode\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &VesaSetupSection1
      }
   };


// =========================================================================

MenuSectionType DisplaySetupSection1 =
   {
   //|_NUM|_CE_| Section Type
         3,  -1, sectiontype_choose,
   //
   // Section Header
   //
   "Standard Modes\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_functionlink,
         "Chained Mode\0", // text
         "Chained VGA modes (mode X)\0", // help
         &DoChainedModeSetup,
         },

         {
         status_active,
         entrytype_functionlink,
         "Vesa 2.0 Linear Graphics Mode\0", // text
         "Page Flipped VESA 2.0 modes\0", // help
         &DoVesaBufferModeSetup,
         },

         {
         status_active,
         entrytype_functionlink,
         "Screen Buffer Mode\0", // text
         "Screen-Buffered VGA/VESA modes\0", // help
         &DoScreenBufferModeSetup,
         },
      }
   };

MenuSectionType DisplaySetupSection2 =
   {
   //|_NUM|_CE_| Section Type
         3,  -1, sectiontype_choose,
   //
   // Section Header
   //
   "Manufacture Specific Modes\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "320x200 Optimized for the TSENG ET4000 chipset\0", // text
         "Only use this mode if your video card has a TSENG ET4000 chipset.\0", // help
         &ScreenMode, // ptr
         screenmode_tseng,
         },

         {
         status_active,
         entrytype_choice,
         "320x200 Optimized for the Paradise WD90Cxxx chipset\0", // text
         "Only use this mode if your video card has a Paradise WD90Cxxx chipset.\0", // help
         &ScreenMode, // ptr
         screenmode_paradise,
         },

         {
         status_active,
         entrytype_choice,
         "320x200 Optimized for the S3 chipset\0", // text
         "Only use this mode if your video card has a S3 chipset.\0", // help
         &ScreenMode, // ptr
         screenmode_s3,
         },
      }
   };

MenuSectionType DisplaySetupSection3 =
   {
   //|_NUM|_CE_| Section Type
         2,  -1, sectiontype_choose,
   //
   // Section Header
   //
   "3D Modes\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "320x200 120 Hz Stereo (Crystal Eyes use only)\0", // text
         "Only use this mode if you are using Crystal Eyes (tm).\0", // help
         &ScreenMode, // ptr
         screenmode_crystal,
         },

         {
         status_active,
         entrytype_choice,
         "320x200 Red-Blue Stereo Vision (VGA Compatible)\0", // text
         "You need Red-Blue glasses to use this mode.\0", // help
         &ScreenMode, // ptr
         screenmode_redblue,
         },
      }
   };

MenuType DisplaySetupMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_|
         3,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Screen Setup\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &DisplaySetupSection1,
      &DisplaySetupSection2,
      &DisplaySetupSection3
      }
   };


#endif
