#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include "types.h"
#include "develop.h"
#include "scriplib.h"
#include "file_lib.h"
#include "gamedefs.h"
#include "keyboard.h"
#include "util_lib.h"
#include "function.h"
#include "control.h"
#include "fx_man.h"
#include "sounds.h"
#include "config.h"
#include "sndcards.h"

// we load this in to get default button and key assignments
// as well as setting up function mappings

#include "function.c"

//
// Sound variables
//
int32 FXDevice;
int32 MusicDevice;
int32 FXVolume;
int32 MusicVolume;
fx_blaster_config BlasterConfig;
int32 NumVoices;
int32 NumChannels;
int32 NumBits;
int32 MixRate;
int32 MidiPort;
int32 ReverseStereo;

int32 ControllerType;

//
// Screen variables
//

int32 ScreenMode;
int32 ScreenWidth;
int32 ScreenHeight;

static char setupfilename[128]={SETUPFILENAME};
static boolean setupread = false;

/*
===================
=
= CONFIG_GetSetupFilename
=
===================
*/
#define MAXSETUPFILES 20
void CONFIG_GetSetupFilename( void )
   {
   struct find_t fblock;
   char extension[10];
   char * src;
   char * filenames[MAXSETUPFILES];
   int32 numfiles;
   int32 i;

   strcpy(setupfilename,SETUPFILENAME);

   // determine extension

   src = setupfilename + strlen(setupfilename) - 1;

   while (*src != '.')
      {
      src--;
      }
   strcpy (&extension[1],src);
   extension[0] = '*';

   numfiles=0;
   if (_dos_findfirst(extension,0,&fblock)==0)
      {
      do
         {
         filenames[numfiles]=SafeMalloc(128);
         strcpy(filenames[numfiles],fblock.name);
         numfiles++;
         }
      while(!_dos_findnext(&fblock));
      }
   i = CheckParm (SETUPNAMEPARM);
   if (i!=0)
      {
      numfiles = 0;
      strcpy(setupfilename,_argv[i+1]);
      }
   if (numfiles>1)
      {
      int32 time;
      int32 oldtime;
      int32 count;

      printf("\nMultiple Configuration Files Encountered\n");
      printf("========================================\n\n");
      printf("Please choose a configuration file from\n");
      printf("the following list by pressing it's\n");
      printf("corresponding letter:\n\n");
      printf("The default file will be used if no selection\n");
      printf("is made within 10 seconds.\n\n");
      for (i=0;i<numfiles;i++)
         {
         if (strcmpi(filenames[i],SETUPFILENAME))
            printf("%c. %s\n",'a'+i,filenames[i]);
         else
            printf("%c. %s <DEFAULT>\n",'a'+i,filenames[i]);
         }
      printf("\n");
      KB_FlushKeyboardQueue();
      KB_ClearKeysDown();
      count = 9;
      oldtime = clock();
      time=clock()+(10*CLOCKS_PER_SEC);
      while (clock()<time)
         {
         if (clock()>oldtime)
            {
            printf("%ld seconds left. \r",count);
            fflush(stdout);
            oldtime = clock()+CLOCKS_PER_SEC;
            count--;
            }
         if (KB_KeyWaiting())
            {
            int32 ch = KB_Getch();
            ch -='a';
            if (ch>=0 && ch<numfiles)
               {
               strcpy (setupfilename, filenames[ch]);
               break;
               }
            }
         }
      printf("\n");
      }
   printf("Using Setup file: %s\n",setupfilename);
   i=clock()+(3*CLOCKS_PER_SEC/4);
   while (clock()<i)
      {
      ;
      }
   for (i=0;i<numfiles;i++)
      {
      SafeFree(filenames[i]);
      }
   }

/*
===================
=
= CONFIG_FunctionNameToNum
=
===================
*/

int32 CONFIG_FunctionNameToNum( char * func )
   {
   int32 i;

   for (i=0;i<NUMGAMEFUNCTIONS;i++)
      {
      if (!stricmp(func,gamefunctions[i]))
         {
         return i;
         }
      }
   return -1;
   }

/*
===================
=
= CONFIG_FunctionNumToName
=
===================
*/

char * CONFIG_FunctionNumToName( int32 func )
   {
   if (func < NUMGAMEFUNCTIONS)
      {
      return gamefunctions[func];
      }
   else
      {
      return NULL;
      }
   }

/*
===================
=
= CONFIG_SetMouseDefaults
=
===================
*/
void CONFIG_SetMouseDefaults( void )
   {
   int32 i;
   int32 function;

   for (i=0;i<MAXMOUSEBUTTONS;i++)
      {
      function = CONFIG_FunctionNameToNum(mousedefaults[i]);
      if (function != -1)
         CONTROL_MapButton( function, i, false );
      function = CONFIG_FunctionNameToNum(mouseclickeddefaults[i]);
      if (function != -1)
         CONTROL_MapButton( function, i, true );
      }
   }

/*
===================
=
= CONFIG_SetJoystickDefaults
=
===================
*/
void CONFIG_SetJoystickDefaults( void )
   {
   int32 i;
   int32 function;

   for (i=0;i<MAXJOYBUTTONS;i++)
      {
      function = CONFIG_FunctionNameToNum(joystickdefaults[i]);
      if (function != -1)
         CONTROL_MapButton( function, i, false );
      function = CONFIG_FunctionNameToNum(joystickclickeddefaults[i]);
      if (function != -1)
         CONTROL_MapButton( function, i, true );
      }
   CONTROL_JoystickPort = 0;
   }

/*
===================
=
= CONFIG_SetDefaultKeys
=
===================
*/
void CONFIG_SetDefaultKeys( void )
   {
   int32 i;
   int32 base;
   int32 function;
   char * keyname1;
   char * keyname2;
   kb_scancode key1,key2;

   for (i=0;i<NUMKEYENTRIES;i++)
      {
      base = i*3;
      function = CONFIG_FunctionNameToNum(keydefaults[base]);
      keyname1 = keydefaults[base+1];
      keyname2 = keydefaults[base+2];
      key1 = 0;
      key2 = 0;
      if (*keyname1)
         {
         key1 = (byte) KB_StringToScanCode( keyname1 );
         }
      if (*keyname2)
         {
         key2 = (byte) KB_StringToScanCode( keyname2 );
         }
      CONTROL_MapKey( function, key1, key2 );
      }
   }

/*
===================
=
= CONFIG_SetDefaults
=
===================
*/

void CONFIG_SetDefaults( void )
   {
   CONTROL_ClearAssignments();
   CONFIG_SetMouseDefaults();
   CONFIG_SetDefaultKeys();
   FXDevice = NumSoundCards;
   MusicDevice = NumSoundCards;
   FXVolume = 128;
   MusicVolume = 128;
   ReverseStereo = 0;
   ControllerType = controltype_keyboardandmouse;
   }

/*
===================
=
= CONFIG_ReadKeys
=
===================
*/

void CONFIG_ReadKeys( void )
   {
   int32 i;
   int32 numkeyentries;
   int32 function;
   char keyname1[80];
   char keyname2[80];
   kb_scancode key1,key2;

   CONFIG_SetDefaultKeys();
   numkeyentries = NumberOfScriptEntries( "KeyDefinitions" );

   for (i=0;i<numkeyentries;i++)
      {
      function = CONFIG_FunctionNameToNum(ScriptEntry( "KeyDefinitions", i ));
      if (function != -1)
         {
         memset(keyname1,0,sizeof(keyname1));
         memset(keyname2,0,sizeof(keyname2));
         GetScriptDoubleString
            (
            "KeyDefinitions",
            ScriptEntry( "KeyDefinitions", i ),
            keyname1,
            keyname2
            );
         key1 = 0;
         key2 = 0;
         if (keyname1[0])
            {
            key1 = (byte) KB_StringToScanCode( keyname1 );
            }
         if (keyname2[0])
            {
            key2 = (byte) KB_StringToScanCode( keyname2 );
            }
         CONTROL_MapKey( function, key1, key2 );
         }
      }
   }

/*
===================
=
= CONFIG_ReadButtons
=
===================
*/

void CONFIG_ReadButtons( void )
   {
   int32 i;
   char str[80];
   char temp[80];
   int32 function;


   if ( ControllerType == controltype_keyboardandmouse )
      {
      CONFIG_SetJoystickDefaults();
      for (i=0;i<MAXMOUSEBUTTONS;i++)
         {
         sprintf(str,"MouseButton%ld",i);
         memset(temp,0,sizeof(temp));
         GetScriptString( "Controls", str,temp);
         function = CONFIG_FunctionNameToNum(temp);
         if (function != -1)
            CONTROL_MapButton( function, i, false );
         sprintf(str,"MouseButtonClicked%ld",i);
         memset(temp,0,sizeof(temp));
         GetScriptString( "Controls", str,temp);
         function = CONFIG_FunctionNameToNum(temp);
         if (function != -1)
            CONTROL_MapButton( function, i, true );
         }
      }

   if (
         ( ControllerType == controltype_keyboardandjoystick ) ||
         ( ControllerType == controltype_keyboardandgamepad )
      )
      {
      CONFIG_SetJoystickDefaults();
      for (i=0;i<MAXJOYBUTTONS;i++)
         {
         sprintf(str,"JoystickButton%ld",i);
         memset(temp,0,sizeof(temp));
         GetScriptString( "Controls", str,temp);
         function = CONFIG_FunctionNameToNum(temp);
         if (function != -1)
            CONTROL_MapButton( function, i, false );
         sprintf(str,"JoystickButtonClicked%ld",i);
         memset(temp,0,sizeof(temp));
         GetScriptString( "Controls", str,temp);
         function = CONFIG_FunctionNameToNum(temp);
         if (function != -1)
            CONTROL_MapButton( function, i, true );
         }
      }
   }

/*
===================
=
= CONFIG_ReadSetup
=
===================
*/

void CONFIG_ReadSetup( void )
   {
   int32 dummy;

   CONFIG_SetDefaults();
   if ( SafeFileExists ( setupfilename ) )
      {
      setupread = true;
      InitScript();
      LoadScript ( setupfilename, false );

      GetScriptNumber( "Screen Setup", "ScreenMode",&ScreenMode);
      GetScriptNumber( "Screen Setup", "ScreenWidth",&ScreenWidth);
      GetScriptNumber( "Screen Setup", "ScreenHeight",&ScreenHeight);

      GetScriptNumber( "Sound Setup", "FXDevice",&FXDevice);
      GetScriptNumber( "Sound Setup", "MusicDevice",&MusicDevice);
      GetScriptNumber( "Sound Setup", "FXVolume",&FXVolume);
      GetScriptNumber( "Sound Setup", "MusicVolume",&MusicVolume);

      GetScriptNumber( "Sound Setup", "NumVoices",&NumVoices);
      GetScriptNumber( "Sound Setup", "NumChannels",&NumChannels);
      GetScriptNumber( "Sound Setup", "NumBits",&NumBits);
      GetScriptNumber( "Sound Setup", "MixRate",&MixRate);
      GetScriptNumber( "Sound Setup", "MidiPort",&MidiPort);
      GetScriptNumber( "Sound Setup", "BlasterAddress",&dummy);
      BlasterConfig.Address = dummy;
      GetScriptNumber( "Sound Setup", "BlasterType",&dummy);
      BlasterConfig.Type = dummy;
      GetScriptNumber( "Sound Setup", "BlasterInterrupt",&dummy);
      BlasterConfig.Interrupt = dummy;
      GetScriptNumber( "Sound Setup", "BlasterDma8",&dummy);
      BlasterConfig.Dma8 = dummy;
      GetScriptNumber( "Sound Setup", "BlasterDma16",&dummy);
      BlasterConfig.Dma16 = dummy;
      GetScriptNumber( "Sound Setup", "BlasterEmu",&dummy);
      BlasterConfig.Emu = dummy;
      GetScriptNumber( "Sound Setup", "ReverseStereo",&ReverseStereo);

      GetScriptNumber( "Controls","ControllerType",&ControllerType);
      GetScriptNumber( "Controls","JoystickPort",&dummy);

      CONTROL_JoystickPort = dummy;

      GetScriptNumber( "Controls","MouseSensitivity",&dummy);
      CONTROL_SetMouseSensitivity(dummy);

      CONTROL_ClearAssignments();

      CONFIG_ReadKeys();

      CONFIG_ReadButtons();
      }
   else
      {
      Error("ReadSetup: %s does not exist\n"
            "           Please run SETUP.EXE\n",setupfilename);
      }
   }

/*
===================
=
= CONFIG_WriteSetup
=
===================
*/

void CONFIG_WriteSetup( void )
   {
   if (setupread)
      {
      int32 dummy;

      PutScriptNumber( "Sound Setup", "FXVolume",FXVolume,false,false);
      PutScriptNumber( "Sound Setup", "MusicVolume",MusicVolume,false,false);
      dummy = CONTROL_GetMouseSensitivity();
      PutScriptNumber( "Controls","MouseSensitivity",dummy,false,false);
      SaveScript (setupfilename);
      FreeScript();
      }
   }

