//****************************************************************************
//
// menus.h
//
// menu definitions
//
//****************************************************************************

#ifndef _menu_private_definitions_
#define _menu_private_definitions_

#include <stddef.h>

typedef struct keyentry
   {
   char * name;
   char * key1;
   char * key2;
   struct keyentry *next;
   struct keyentry *prev;
   } KeyEntryType;


char * SoundCardName( int32 card );
char * ControllerTypeName( int32 type );
char * BlasterTypeName( int32 type );
void ClearKeyDef( char * functionname, int32 whichkey );

#include "com_menu.h"
#include "snd_menu.h"
#include "scn_menu.h"
#include "cntrlmnu.h"

// =========================================================================
// Main Menu
// Main Menu Section 1

MenuSectionType MainMenuSection1 =
   {
   //|_NUM|_CE_| Section Type
         1,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
         {
         {
         status_display,
         entrytype_displaystring,
         "Current Filename\0", // text
         "\0", // help
         &setupfilename[0], // ptr
         13,
         }
      }
   };
// =========================================================================
// Main Menu
// Main Menu Section 2
MenuSectionType MainMenuSection2 =
   {
   //|_NUM|_CE_| Section Type
         8,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   "\0",
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_menulink,
         "Sound Setup\0", // text
         "Setup sound and music for " GAMENAME "\0", // help
         &SoundSetupMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Screen Setup\0", // text
         "Setup screen modes for " GAMENAME "\0", // help
         &DisplaySetupMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Controller Setup\0",
         "Setup controls.  Change button and key assignments.\0", // help
         &ControlMenu,
         },

         {
         status_active,
         entrytype_menulink,
         "Network Game\0", // text
         "Play a network game of " GAMENAME "\0", // help
         &NetworkGameMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Modem Game\0", // text
         "Play a modem game of " GAMENAME "\0", // help
         &ModemGameMenu, // ptr
         },

         {
         status_active,
         entrytype_menulink,
         "Serial Game\0", // text
         "Play a serial game of " GAMENAME "\0", // help
         &SerialGameMenu,
         },

         {
         status_active,
         entrytype_string,
         "Change Setup Filename\0", // text
         "Changes the filename of the SETUP configuration file for " GAMENAME "\0", // help
         &setupfilename[0],
         13
         },

         {
         status_active,
         entrytype_functionlink,
         "Save and launch " GAMENAME "\0",
         "Save the current setup and play " GAMENAME "\0", // help
         &LaunchGame,
         },



      }
   };

MenuType MainMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         2,  -1,  -1,menutype_leftjustified,
   // Window Header
      "Main Menu\0",
   // Window Footer
      MENUFOOTER,
   //
   // menu body
   //
      {
      &MainMenuSection1,
      &MainMenuSection2
      }
   };

MenuSectionType QuitSection1 =
   {
   //|_NUM|_CE_| Section Type
         2,  -1, sectiontype_stayup,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_display,
         entrytype_functionlink,
         "Save Settings\0", // text
         "\0", // help
         NULL, // ptr
         },
         {
         status_display,
         entrytype_functionlink,
         "before exiting?\0", // text
         "\0", // help
         NULL, // ptr
         },
      }
   };

MenuSectionType QuitSection2 =
   {
   //|_NUM|_CE_| Section Type
         2,  -1, sectiontype_choose,
   //
   // Section Header
   //
   NULL,
   //
   // menu body
   //
      {
         {
         status_active,
         entrytype_choice,
         "Yes\0", // text
         "Save current setup and exit setup program\0", // help
         &SaveSetup, // ptr
         1,
         },

         {
         status_active,
         entrytype_choice,
         "No\0", // text
         "Do not save current setup, but exit setup program\0", // help
         &SaveSetup, // ptr
         0,
         },
      }
   };

MenuType QuitMenu =
   {
   //|_NUM|_CS_|_WH_|_MT_
         2,  -1,  -1,menutype_centered,
   // Window Header
      NULL,
   // Window Footer
      "Esc Aborts\0",
   //
   // menu body
   //
      {
      &QuitSection1,
      &QuitSection2,
      }
   };


#endif









/*

         {
         status_active,
         entrytype_value,
         "Use Stereo Sound\0", // text
         "Use Stereo Sound in all sound FX\0", // help
         &usestereo, // ptr
         1
         },

         {
         status_active,
         entrytype_value,
         "Use Stereo Sound 2\0", // text
         "Use Stereo Sound in all sound FX\0", // help
         &usestereo, // ptr
         2
         },
         {
         status_active,
         entrytype_displaystring,
         "teststring\0", // text
         "Some crazy string\0", // help
         &teststring, // ptr
         20
         },
         {
         status_active,
         entrytype_entervalue,
         "usestereo\0", // text
         "Some crazy string\0", // help
         &usestereo, // ptr
         valuetype_hexadecimal,
         0,       // min
         0xffff   // max
         },
         {
         status_active,
         entrytype_entervalue,
         "usestereo\0", // text
         "Some crazy string\0", // help
         &usestereo, // ptr
         valuetype_slider,
         0,       // min
         255      // max
         },

*/
