/**********************************************************************
   module: MUSIC.H

   author: James R. Dos
   phone:  (214)-271-1365 Ext #221
   date:   March 25, 1994

   Public header for MUSIC.C

   (c) Copyright 1994 James R. Dos.  All Rights Reserved.
**********************************************************************/

#ifndef __MUSIC_H
#define __MUSIC_H

#include "sndcards.h"

extern int MUSIC_ErrorCode;

enum MUSIC_ERRORS
   {
   MUSIC_Warning = -2,
   MUSIC_Error   = -1,
   MUSIC_Ok      = 0,
   MUSIC_ASSVersion,
   MUSIC_SoundCardError,
   MUSIC_MPU401Error,
   MUSIC_InvalidCard,
   MUSIC_MidiError,
   MUSIC_TaskManError,
   MUSIC_FMNotDetected,
   MUSIC_DPMI_Error
   };

#define MUSIC_LoopSong ( 1 == 1 )
#define MUSIC_PlayOnce ( !MUSIC_LoopSong )

char *MUSIC_ErrorString( int ErrorNumber );
int   MUSIC_Init( int SoundCard, int Address );
int   MUSIC_Shutdown( void );
void  MUSIC_SetVolume( int volume );
void  MUSIC_SetMidiChannelVolume( int channel, int volume );
void  MUSIC_ResetMidiChannelVolumes( void );
int   MUSIC_GetVolume( void );
void  MUSIC_SetLoopFlag( int loopflag );
int   MUSIC_SongPlaying( void );
void  MUSIC_Continue( void );
void  MUSIC_Pause( void );
int   MUSIC_StopSong( void );
int   MUSIC_PlaySong( unsigned char *song, int loopflag );
unsigned long MUSIC_GetPosition( void );
void  MUSIC_SetPosition( unsigned long PositionInTicks );
int   MUSIC_FadeVolume( int tovolume, int milliseconds );
int   MUSIC_FadeActive( void );
void  MUSIC_StopFade( void );
void  MUSIC_RerouteMidiChannel( int channel, int cdecl ( *function )( int event, int c1, int c2 ) );
void  MUSIC_RegisterTimbreBank( unsigned char *timbres );

#endif
