//****************************************************************************
//
// menudefs.h
//
// menu defines and types
//
//****************************************************************************

#ifndef _menudefs_public_
#define _menudefs_public_

//****************************************************************************
//
// Menu entry types
//
//****************************************************************************


typedef struct
   {
   int8 type;
   int8 status;
   char * textstring;
   char * helpstring;
   void * ptr;
   } BooleanButtonType;

typedef struct
   {
   int8 type;
   int8 status;
   char * textstring;
   char * helpstring;
   void * ptr;
   int32 value;
   } ValueType;

typedef struct
   {
   int8 type;
   int8 status;
   char * textstring;
   char * helpstring;
   void * ptr;
   int32 valuetype;
   int32 minimum;
   int32 maximum;
   } EnterValueType;

typedef struct
   {
   int8 type;
   int8 status;
   char * textstring;
   char * helpstring;
   void * ptr;
   int32 maxlength;
   } StringType;

typedef struct
   {
   int8 type;
   int8 status;
   char * string1;
   char * helpstring;
   int32 maxlength1;
   char * string2;
   int32 maxlength2;
   char * description1;
   char * description2;
   char * dest;
   } DualStringType;

typedef struct
   {
   int8 type;
   int8 status;
   char * textstring;
   char * helpstring;
   void * menuptr;
   } DisplayMenuType;

typedef struct
   {
   int8 type;
   int8 status;
   char * textstring;
   char * helpstring;
   void * funcptr;
   void * valueptr;
   } TranslateValueType;

typedef struct
   {
   int8 status;
   int8 type;
   char * textstring;
   char * helpstring;
   char * filename;
   int32  numfields;
   void * field1;
   void * field2;
   void * field3;
   void * field4;
   } FromFileType;

typedef BooleanButtonType FromFunctionsType;

typedef struct
   {
   int8 status;
   int8 type;
   char * textstring;
   char * helpstring;
   void * ptr;
   void * ptr1;
   void * ptr2;
   void * ptr3;
   void * ptr4;
   void * ptr5;
   void * ptr6;
//   int32 value1;
//   int32 value2;
//   int32 value3;
//   char * string1;
//   char * string2;
//   char * string3;
   } MenuEntryType;

typedef struct
   {
   int8 status;
   int8 type;
   char * textstring;
   char * helpstring;
   void * ptr;
   } MenuLinkType;

typedef struct
   {
   int8 status;
   int8 type;
   char * textstring;
   char * helpstring;
   void * ptr;
   int32 value;
   } FunctionLinkType;

typedef struct
   {
   int16 numentries;
   int16 currententry;
   int16 sectiontype;
   char  * header;
   MenuEntryType entries[];
   } MenuSectionType;


typedef struct
   {
   int16 numsections;
   int16 currentsection;
   int16 windowhandle;
   int16 menutype;
   char  * header;
   char  * footer;
   MenuSectionType * sections[];
   } MenuType;

// Menu Statuses for entries

typedef enum
   {
   status_inactive,
   status_display,
   status_active
   };

// Menu Entry Types

typedef enum
   {
   entrytype_menulink,
   entrytype_functionlink,
   entrytype_togglebutton,
   entrytype_string,
   entrytype_value,
   entrytype_choice,
   entrytype_entervalue,
   entrytype_displayvalue,
   entrytype_displaystring,
   entrytype_displaymenu,
   entrytype_dualstring,
   entrytype_translatevalue,
   entrytype_fromfile,
   entrytype_fromfunctions
   };

// Menu Section Types

typedef enum
   {
   sectiontype_stayup,
   sectiontype_choose
   };

typedef enum
   {
   menutype_leftjustified,
   menutype_centered
   };

// Value Types

typedef enum
   {
   valuetype_decimal,
   valuetype_hexadecimal,
   valuetype_slider
   };

#endif
