#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>

#include "types.h"
#include "develop.h"
#include "scriplib.h"
#include "file_lib.h"
#include "common.h"
#include "gamedefs.h"
#include "menudefs.h"
#include "fx_man.h"
#include "menus.h"
#include "menu_lib.h"
#include "keyboard.h"
#include "util_lib.h"
#include "config.h"
#include "function.h"
#include "control.h"

#include "function.c"

//
// Sound variables
//
int32 FXDevice;
int32 MusicDevice;
int32 FXVolume;
int32 MusicVolume;
fx_blaster_config BlasterConfig;
int32 NumVoices;
int32 NumChannels;
int32 NumBits;
int32 MixRate;
int32 MidiPort;
int32 ReverseStereo;

//
// Screen variables
//
int32 ScreenMode;
int32 ScreenWidth;
int32 ScreenHeight;
int32 ScreenBufferMode;
int32 VesaBufferMode;



//
// Comm variables
//
int32 ComPort;
int32 IrqNumber;
int32 UartAddress;
int32 PortSpeed;

int32 ToneDial;
char  ModemName[MAXMODEMSTRING];
char  InitString[MAXMODEMSTRING];
char  HangupString[MAXMODEMSTRING];
char  DialoutString[MAXMODEMSTRING];
int32 SocketNumber;
char  CommbatMacro[MAXMACROS][MAXMACROLENGTH];
char  PhoneNames[MAXPHONEENTRIES][PHONENAMELENGTH];
char  PhoneNumbers[MAXPHONEENTRIES][PHONENUMBERLENGTH];
char  PhoneNumber[PHONENUMBERLENGTH];

char  PlayerName[MAXPLAYERNAMELENGTH];

char  MouseButtons[MAXMOUSEBUTTONS][MAXFUNCTIONLENGTH];
char  MouseButtonsClicked[MAXMOUSEBUTTONS][MAXFUNCTIONLENGTH];

char  JoystickButtons[MAXJOYBUTTONS][MAXFUNCTIONLENGTH];
char  JoystickButtonsClicked[MAXJOYBUTTONS][MAXFUNCTIONLENGTH];

int32 ControllerType;
int32 JoystickPort;
int32 MouseSensitivity;

int32 NumberPlayers;

int32 ConnectType=0;

char setupfilename[128]={SETUPFILENAME};

/*
===================
=
= GetBlasterString
=
===================
*/

#define BlasterEnv_Address    'A'
#define BlasterEnv_Interrupt  'I'
#define BlasterEnv_8bitDma    'D'
#define BlasterEnv_16bitDma   'H'
#define BlasterEnv_Type       'T'
#define BlasterEnv_Midi       'P'
#define BlasterEnv_EmuAddress 'E'

void GetBlasterString
   (
   fx_blaster_config *Config
   )

   {
   char *Blaster;
   char parameter;

   Config->Address   = 0x220;
   Config->Type      = fx_SB;
   Config->Interrupt = 5;
   Config->Dma8      = 1;
   Config->Dma16     = 5;
   Config->Midi      = 0x330;
   Config->Emu       = 0x620;

   Blaster = getenv( "BLASTER" );
   if ( Blaster == NULL )
      {
      return;
      }

   while( *Blaster != 0 )
      {
      if ( *Blaster == ' ' )
         {
         Blaster++;
         continue;
         }

      parameter = toupper( *Blaster );
      Blaster++;

      if ( !isxdigit( *Blaster ) )
         {
         return;
         }

      switch( parameter )
         {
         case BlasterEnv_Address :
            sscanf( Blaster, "%x", &Config->Address );
            break;
         case BlasterEnv_Interrupt :
            sscanf( Blaster, "%d", &Config->Interrupt );
            break;
         case BlasterEnv_8bitDma :
            sscanf( Blaster, "%d", &Config->Dma8 );
            break;
         case BlasterEnv_Type :
            sscanf( Blaster, "%d", &Config->Type );
            break;
         case BlasterEnv_16bitDma :
            sscanf( Blaster, "%d", &Config->Dma16 );
            break;
         case BlasterEnv_Midi :
            sscanf( Blaster, "%x", &Config->Midi );
            break;
         case BlasterEnv_EmuAddress :
            sscanf( Blaster, "%x", &Config->Emu );
            break;
         default  :
            // Skip the offending data
            // sscanf( Blaster, "%*s" );
            break;
         }

      while( isxdigit( *Blaster ) )
         {
         Blaster++;
         }
      }
   }
/*
===================
=
= SetDefaultKeyDefinitions
=
===================
*/
void SetDefaultKeyDefinitions( void )
   {
   int32 i;
   int32 base;
   char * functionname;
   char * keyname1;
   char * keyname2;

   for (i=0;i<NUMKEYENTRIES;i++)
      {
      base = i*3;
      functionname = keydefaults[base];
      keyname1 = keydefaults[base+1];
      keyname2 = keydefaults[base+2];
      if (*keyname1)
         {
         AddKeyFunction( functionname );
         AddKeyDef( functionname, keyname1, 0 );
         }
      if (*keyname2)
         {
         AddKeyFunction( functionname );
         AddKeyDef( functionname, keyname2, 1 );
         }
      }
   }


/*
===================
=
= SetMouseDefaults
=
===================
*/
void SetMouseDefaults( void )
   {
   int32 i;

   MouseSensitivity = 32768;
   for (i=0;i<MAXMOUSEBUTTONS;i++)
      {
      if (mousedefaults[i])
         strcpy(MouseButtons[i],mousedefaults[i]);
      if (mouseclickeddefaults[i])
         strcpy(MouseButtonsClicked[i],mouseclickeddefaults[i]);
      }
   }

/*
===================
=
= SetJoystickDefaults
=
===================
*/
void SetJoystickDefaults( void )
   {
   int32 i;

   JoystickPort = 0;
   for (i=0;i<MAXJOYBUTTONS;i++)
      {
      if (joystickdefaults[i])
         strcpy(JoystickButtons[i],joystickdefaults[i]);
      if (joystickclickeddefaults[i])
         strcpy(JoystickButtonsClicked[i],joystickclickeddefaults[i]);
      }
   }

/*
===================
=
= SetDefaults
=
===================
*/

void SetDefaults( void )
   {
#ifdef __FLAT__
   fx_blaster_config blaster;
   int32 status;

   status = FX_GetBlasterSettings( &blaster );
   if ( status == FX_Ok )
      {
      BlasterConfig.Type      = blaster.Type;
      BlasterConfig.Address   = blaster.Address;
      BlasterConfig.Interrupt = blaster.Interrupt;
      BlasterConfig.Dma8      = blaster.Dma8;
      BlasterConfig.Dma16     = blaster.Dma16;
      BlasterConfig.Midi      = blaster.Midi;
      BlasterConfig.Emu       = blaster.Emu;
      MidiPort = BlasterConfig.Midi;
      }
#else
   GetBlasterString( &BlasterConfig );
#endif

   ScreenMode = 1;
   ScreenWidth = 320;
   ScreenHeight = 200;

   FXDevice = NumSoundCards;
   MusicDevice = NumSoundCards;
   FXVolume = 128;
   MusicVolume = 128;
   ReverseStereo = 0;

   ComPort = 2;
   IrqNumber = -1;
   UartAddress = -1;
   PortSpeed = 9600;
   ToneDial = 1;
   SocketNumber = -1;
   NumberPlayers = 2;
   strcpy (InitString,"ATZ\0");
   strcpy (HangupString,"ATH0=0\0");
   DialoutString[0]='\0';
   strcpy (PlayerName,"PLAYER\0");
   ControllerType = controltype_keyboard;
   SetMouseDefaults();
   SetJoystickDefaults();
   SetDefaultKeyDefinitions();
   }

/*
===================
=
= ReadSetup
=
===================
*/

void ReadSetup( void )
   { g
   int32 i;
   char str[80];

   SetDefaults();
   InitScript();

   if ( !SafeFileExists ( setupfilename ) )
      {
      WriteSetup(true);
      }

   LoadScript ( setupfilename, false );

   GetScriptNumber( "Screen Setup","ScreenMode",&ScreenMode);
   GetScriptNumber( "Screen Setup","ScreenWidth",&ScreenWidth);
   GetScriptNumber( "Screen Setup","ScreenHeight",&ScreenHeight);

   GetScriptNumber( "Sound Setup", "FXDevice",&FXDevice);
   GetScriptNumber( "Sound Setup", "MusicDevice",&MusicDevice);
   GetScriptNumber( "Sound Setup", "FXVolume",&FXVolume);
   GetScriptNumber( "Sound Setup", "MusicVolume",&MusicVolume);

   GetScriptNumber( "Sound Setup", "NumVoices",&NumVoices);
   GetScriptNumber( "Sound Setup", "NumChannels",&NumChannels);
   GetScriptNumber( "Sound Setup", "NumBits",&NumBits);
   GetScriptNumber( "Sound Setup", "MixRate",&MixRate);
   GetScriptNumber( "Sound Setup", "MidiPort",&MidiPort);
   GetScriptNumber( "Sound Setup", "BlasterAddress",(int32 *)&BlasterConfig.Address);
   GetScriptNumber( "Sound Setup", "BlasterType",(int32 *)&BlasterConfig.Type);
   GetScriptNumber( "Sound Setup", "BlasterInterrupt",(int32 *)&BlasterConfig.Interrupt);
   GetScriptNumber( "Sound Setup", "BlasterDma8",(int32 *)&BlasterConfig.Dma8);
   GetScriptNumber( "Sound Setup", "BlasterDma16",(int32 *)&BlasterConfig.Dma16);
   GetScriptNumber( "Sound Setup", "BlasterEmu",(int32 *)&BlasterConfig.Emu);
   GetScriptNumber( "Sound Setup", "ReverseStereo",&ReverseStereo);

   GetScriptNumber( "Comm Setup", "ComPort",&ComPort);
   GetScriptNumber( "Comm Setup", "IrqNumber",&IrqNumber);
   GetScriptNumber( "Comm Setup", "UartAddress",&UartAddress);
   GetScriptNumber( "Comm Setup", "PortSpeed",&PortSpeed);
   GetScriptNumber( "Comm Setup", "ToneDial",&ToneDial);
   GetScriptNumber( "Comm Setup", "SocketNumber",&SocketNumber);
   GetScriptNumber( "Comm Setup", "NumberPlayers",&NumberPlayers);
   GetScriptString( "Comm Setup", "ModemName",ModemName);
   GetScriptString( "Comm Setup", "InitString",InitString);
   GetScriptString( "Comm Setup", "HangupString",HangupString);
   GetScriptString( "Comm Setup", "DialoutString",DialoutString);
   GetScriptString( "Comm Setup", "PlayerName",PlayerName);

   for (i=0;i<MAXMACROS;i++)
      {
      sprintf(str,"CommbatMacro#%ld",i);
      GetScriptString( "Comm Setup", str,CommbatMacro[i]);
      }

   for (i=0;i<MAXPHONEENTRIES;i++)
      {
      sprintf(str,"PhoneName#%ld",i);
      GetScriptString( "Comm Setup", str,PhoneNames[i]);
      sprintf(str,"PhoneNumber#%ld",i);
      GetScriptString( "Comm Setup", str,PhoneNumbers[i]);
      }

   GetScriptNumber( "Controls","ControllerType",&ControllerType);
   GetScriptNumber( "Controls","JoystickPort",&JoystickPort);
   GetScriptNumber( "Controls","MouseSensitivity",&MouseSensitivity);

   for (i=0;i<MAXMOUSEBUTTONS;i++)
      {
      // initialize to undefined
      strcpy(MouseButtons[i],"");
      strcpy(MouseButtonsClicked[i],"");
      sprintf(str,"MouseButton%ld",i);
      GetScriptString( "Controls", str,MouseButtons[i]);
      sprintf(str,"MouseButtonClicked%ld",i);
      GetScriptString( "Controls", str,MouseButtonsClicked[i]);
      }
   for (i=0;i<MAXJOYBUTTONS;i++)
      {
      // initialize to undefined
      strcpy(JoystickButtons[i],"");
      strcpy(JoystickButtonsClicked[i],"");
      sprintf(str,"JoystickButton%ld",i);
      GetScriptString( "Controls", str,JoystickButtons[i]);
      sprintf(str,"JoystickButtonClicked%ld",i);
      GetScriptString( "Controls", str,JoystickButtonsClicked[i]);
      }
   InitializeKeyDefinitions();
   }

/*
===================
=
= WriteSetup
=
===================
*/

void WriteSetup( boolean docomments )
   {
   int32 i;
   char str[80];

   FreeScript();
   InitScript();
   if ( !SafeFileExists ( setupfilename ) )
      {
      docomments = true;
      }
   else if (!docomments)
      {
      LoadScript ( setupfilename, false );
      }

   if (docomments)
      {
      PutScriptComment( "Setup File for " GAMENAME "");
      PutScriptMultiComment( "Version %s",SETUPPROGRAMVERSION);
      PutScriptEOL();
      PutScriptEOL();
      PutScriptComment("ScreenSetup");
      PutScriptEOL();
      PutScriptComment("ScreenMode");
      PutScriptMultiComment(" - Chained - %d",screenmode_chained);
      PutScriptMultiComment(" - Vesa 2.0 - %d",screenmode_vesa);
      PutScriptMultiComment(" - Screen Buffered - %d",screenmode_buffered);
      PutScriptMultiComment(" - Tseng optimized - %d",screenmode_tseng);
      PutScriptMultiComment(" - Paradise optimized - %d",screenmode_paradise);
      PutScriptMultiComment(" - S3 optimized - %d",screenmode_s3);
      PutScriptMultiComment(" - RedBlue Stereo - %d",screenmode_redblue);
      PutScriptMultiComment(" - Crystal Eyes - %d",screenmode_crystal);
      PutScriptEOL();
      PutScriptComment("ScreenWidth passed to engine");
      PutScriptEOL();
      PutScriptComment("ScreenHeight passed to engine");
      PutScriptEOL();
      PutScriptEOL();
      }

//   PutScriptSectionHeader( "Screen Setup");
   PutScriptNumber( "Screen Setup","ScreenMode",ScreenMode,false,false);
   PutScriptNumber( "Screen Setup","ScreenWidth",ScreenWidth,false,false);
   PutScriptNumber( "Screen Setup","ScreenHeight",ScreenHeight,false,false);

   if (docomments)
      {
      PutScriptEOL();
      PutScriptEOL();
      }

//   PutScriptSectionHeader( "Sound Setup");
   PutScriptNumber( "Sound Setup","FXDevice",FXDevice,false,false);
   PutScriptNumber( "Sound Setup","MusicDevice",MusicDevice,false,false);
   PutScriptNumber( "Sound Setup","FXVolume",FXVolume,false,false);
   PutScriptNumber( "Sound Setup","MusicVolume",MusicVolume,false,false);
   PutScriptNumber( "Sound Setup","NumVoices",NumVoices,false,false);
   PutScriptNumber( "Sound Setup","NumChannels",NumChannels,false,false);
   PutScriptNumber( "Sound Setup","NumBits",NumBits,false,false);
   PutScriptNumber( "Sound Setup","MixRate",MixRate,false,false);
   PutScriptNumber( "Sound Setup","MidiPort",MidiPort,true,false);
   PutScriptNumber( "Sound Setup","BlasterAddress",BlasterConfig.Address,true,false);
   PutScriptNumber( "Sound Setup","BlasterType",BlasterConfig.Type,false,false);
   PutScriptNumber( "Sound Setup","BlasterInterrupt",BlasterConfig.Interrupt,false,false);
   PutScriptNumber( "Sound Setup","BlasterDma8",BlasterConfig.Dma8,false,false);
   PutScriptNumber( "Sound Setup","BlasterDma16",BlasterConfig.Dma16,false,false);
   PutScriptNumber( "Sound Setup","BlasterEmu",BlasterConfig.Emu,true,false);
   PutScriptNumber( "Sound Setup","ReverseStereo",ReverseStereo,false,false);

   if (docomments)
      {
      PutScriptEOL();
      PutScriptEOL();
      }

   WriteKeyDefinitions();

   if (docomments)
      {
      PutScriptEOL();
      PutScriptEOL();
      PutScriptComment("Controls");
      PutScriptEOL();
      PutScriptComment("ControllerType");
      PutScriptMultiComment(" - Keyboard - %d",controltype_keyboard);
      PutScriptMultiComment(" - Keyboard and Mouse - %d",controltype_keyboardandmouse);
      PutScriptMultiComment(" - Keyboard and Joystick - %d",controltype_keyboardandjoystick);
      PutScriptMultiComment(" - Keyboard and Gamepad - %d",controltype_keyboardandgamepad);
      PutScriptMultiComment(" - Keyboard and Spaceball - %d",controltype_keyboardandspaceball);
      PutScriptMultiComment(" - Keyboard and Wingman Assassin - %d",controltype_keyboardandassassin);
      PutScriptEOL();
      PutScriptEOL();
      }
//   PutScriptSectionHeader( "Controls");
   PutScriptNumber( "Controls","ControllerType",ControllerType,false,false);
   PutScriptNumber( "Controls","JoystickPort",JoystickPort,false,false);
   PutScriptNumber( "Controls","MouseSensitivity",MouseSensitivity,false,false);

   for (i=0;i<MAXMOUSEBUTTONS;i++)
       {
       sprintf(str,"MouseButton%ld",i);
       PutScriptString( "Controls",str,MouseButtons[i] );
       sprintf(str,"MouseButtonClicked%ld",i);
       PutScriptString( "Controls",str,MouseButtonsClicked[i] );
       }
   for (i=0;i<MAXJOYBUTTONS;i++)
       {
       sprintf(str,"JoystickButton%ld",i);
       PutScriptString( "Controls",str,JoystickButtons[i] );
       sprintf(str,"JoystickButtonClicked%ld",i);
       PutScriptString( "Controls",str,JoystickButtonsClicked[i] );
       }

   if (docomments)
      {
      PutScriptEOL();
      PutScriptEOL();
      }
//   PutScriptSectionHeader( "Comm Setup");
   PutScriptNumber( "Comm Setup","ComPort",ComPort,false,false);
   PutScriptNumber( "Comm Setup","IrqNumber",IrqNumber,false,(IrqNumber == -1));
   PutScriptNumber( "Comm Setup","UartAddress",UartAddress,true,(UartAddress == -1));
   PutScriptNumber( "Comm Setup","PortSpeed",PortSpeed,false,false);
   PutScriptNumber( "Comm Setup","ToneDial",ToneDial,false,false);
   PutScriptNumber( "Comm Setup","SocketNumber",SocketNumber,true,(SocketNumber == -1));
   PutScriptNumber( "Comm Setup","NumberPlayers",NumberPlayers,false,false);
   PutScriptString( "Comm Setup","ModemName",ModemName);
   PutScriptString( "Comm Setup","InitString",InitString);
   PutScriptString( "Comm Setup","HangupString",HangupString);
   PutScriptString( "Comm Setup","DialoutString",DialoutString);
   PutScriptString( "Comm Setup","PlayerName",PlayerName);

   for (i=0;i<MAXMACROS;i++)
      {
      sprintf(str,"CommbatMacro#%ld",i);
      PutScriptString( "Comm Setup",str,CommbatMacro[i]);
      }

   for (i=0;i<MAXPHONEENTRIES;i++)
      {
      sprintf(str,"PhoneName#%ld",i);
      PutScriptString( "Comm Setup",str,PhoneNames[i]);
      sprintf(str,"PhoneNumber#%ld",i);
      PutScriptString( "Comm Setup",str,PhoneNumbers[i]);
      }

   SaveScript(setupfilename);
   FreeScript();
   }

/*
===================
=
= WriteCommitFile
=
===================
*/

void WriteCommitFile( int32 gametype )
   {
   char str[80];

   InitScript();

   PutScriptComment("COMMIT data file");
   PutScriptEOL();
   PutScriptComment("This data file defines the configurable options of COMMIT.  Presumably,");
   PutScriptComment("the user never sees this file, but rather it is setup by another");
   PutScriptComment("program which launches COMMIT.");
   PutScriptEOL();
   PutScriptEOL();
   PutScriptComment("COMMTYPE");
   PutScriptMultiComment(" - SERIAL - %d",gametype_serial);
   PutScriptMultiComment(" - MODEM - %d",gametype_modem);
   PutScriptMultiComment(" - NETWORK - %d",gametype_network);
   PutScriptEOL();
   PutScriptComment(" NUMPLAYERS");
   PutScriptComment(" - 0..MAXPLAYERS");
   PutScriptEOL();
   PutScriptComment(" VECTOR");
   PutScriptComment(" - ~ find an empty one");
   PutScriptComment(" - 0x60..0x69 specify one");
   PutScriptEOL();
   PutScriptComment(" CONNECTTYPE");
   PutScriptMultiComment(" - DIALMODE - %d",connecttype_dialing);
   PutScriptMultiComment(" - ANSWERMODE - %d",connecttype_answer);
   PutScriptMultiComment(" - ALREADYCONNECTED - %d",connecttype_alreadyconnected);
   PutScriptEOL();

//   PutScriptSectionHeader( "Commit");
   PutScriptNumber( "Commit","COMMTYPE",gametype,false,false);
   switch (gametype)
      {
      case gametype_network:
         PutScriptNumber( "Commit","NUMPLAYERS",NumberPlayers,false,false);
         break;
      case gametype_serial:
      case gametype_modem:
         PutScriptNumber( "Commit","NUMPLAYERS",2,false,false);
         break;
      }
   PutScriptNumber( "Commit","PAUSE",0,false,false);
   PutScriptNumber( "Commit","VECTOR",0,false,true);
   if (SocketNumber == -1)
      PutScriptNumber( "Commit","SOCKETNUMBER",DEFAULTSOCKETNUMBER,false,false);
   else
      PutScriptNumber( "Commit","SOCKETNUMBER",SocketNumber,false,false);
   PutScriptString( "Commit","INITSTRING",InitString);
   PutScriptString( "Commit","HANGUPSTRING",HangupString);
   sprintf(str,"%s%s",DialoutString,PhoneNumber);
   PutScriptString( "Commit","PHONENUMBER",str);
   PutScriptString( "Commit","LAUNCHNAME",GAMELAUNCHER);
   PutScriptNumber( "Commit","CONNECTTYPE",ConnectType,false,false);
   PutScriptNumber( "Commit","USETONE",ToneDial,false,false);
   PutScriptNumber( "Commit","COMPORT",ComPort,false,false);
   PutScriptNumber( "Commit","IRQNUMBER",IrqNumber,false,(IrqNumber == -1));
   PutScriptNumber( "Commit","UARTADDRESS",UartAddress,true,(UartAddress == -1));
   PutScriptNumber( "Commit","PORTSPEED",PortSpeed,false,false);
   PutScriptNumber( "Commit","SHOWSTATS",0,false,false);

   SaveScript ( COMMITFILENAME );
   FreeScript ();
   }


/*
===================
=
= GetSetupFilename
=
===================
*/
#define MAXSETUPFILES 20
void GetSetupFilename( void )
   {
   struct find_t fblock;
   char extension[10];
   char * src;
   char * filenames[MAXSETUPFILES];
   int32 numfiles;
   int32 i;

   strcpy(setupfilename,SETUPFILENAME);

   // determine extension

   src = setupfilename + strlen(setupfilename) - 1;

   while (*src != '.')
      {
      src--;
      }
   strcpy (&extension[1],src);
   extension[0] = '*';

   numfiles=0;
   if (_dos_findfirst(extension,0,&fblock)==0)
      {
      do
         {
         filenames[numfiles]=SafeMalloc(128);
         strcpy(filenames[numfiles],fblock.name);
         numfiles++;
         }
      while(!_dos_findnext(&fblock));
      }
   i = CheckParm (SETUPNAMEPARM);
   if (i!=0)
      {
      numfiles = 0;
      strcpy(setupfilename,_argv[i+1]);
      }
   if (numfiles>1)
      {
      int32 time;
      int32 oldtime;
      int32 count;

      printf("\nMultiple Configuration Files Encountered\n");
      printf("========================================\n\n");
      printf("Please choose a configuration file from\n");
      printf("the following list by pressing it's\n");
      printf("corresponding letter:\n\n");
      printf("The default file will be used if no selection\n");
      printf("is made within 10 seconds.\n\n");
      for (i=0;i<numfiles;i++)
         {
         if (strcmpi(filenames[i],SETUPFILENAME))
            printf("%c. %s\n",'a'+i,filenames[i]);
         else
            printf("%c. %s <DEFAULT>\n",'a'+i,filenames[i]);
         }
      printf("\n");
      KB_FlushKeyboardQueue();
      KB_ClearKeysDown();
      count = 9;
      oldtime = clock();
      time=clock()+(10*CLOCKS_PER_SEC);
      while (clock()<time)
         {
         if (clock()>oldtime)
            {
            printf("%ld seconds left. \r",count);
            fflush(stdout);
            oldtime = clock()+CLOCKS_PER_SEC;
            count--;
            }
         if (KB_KeyWaiting())
            {
            int32 ch = KB_Getch();
            ch -='a';
            if (ch>=0 && ch<numfiles)
               {
               strcpy (setupfilename, filenames[ch]);
               break;
               }
            }
         }
      printf("\n");
      }
   printf("Using Setup file: %s\n",setupfilename);
   i=clock()+(3*CLOCKS_PER_SEC/4);
   while (clock()<i)
      {
      ;
      }
   for (i=0;i<numfiles;i++)
      {
      SafeFree(filenames[i]);
      }
   }

