// scrplib.h

#ifndef _scriplib_private
#define _scriplib_private

#define SCRIPTSECTIONSTART ('[')
#define SCRIPTSECTIONEND   (']')
#define SCRIPTENTRYSEPARATOR ('=')
#define SCRIPTCOMMENT      (';')
#define SCRIPTEOL          ('\n')
#define SCRIPTNULL         ('\0')
#define SCRIPTSTRINGSEPARATOR ('"')
#define SCRIPTHEXFIRST ('0')
#define SCRIPTHEXSECOND ('x')
#define SCRIPTSPACE     (' ')
#define SCRIPTDEFAULTVALUE ('~')

typedef enum
   {
   linetype_comment,
   linetype_section,
   linetype_entry
   } linetype_t;

typedef struct scriptline
   {
   int32  type;
   void * ptr;
   struct scriptline *nextline;
   struct scriptline *prevline;
   } ScriptLineType;

typedef struct scriptentry
   {
   char * name;
   char * value;
   struct scriptentry *nextentry;
   struct scriptentry *preventry;
   } ScriptEntryType;

typedef struct scriptsection
   {
   char * name;
   ScriptEntryType      *entries;
   ScriptLineType       *lastline;
   struct scriptsection *nextsection;
   struct scriptsection *prevsection;
   } ScriptSectionType;

#endif
