//***************************************************************************
//
//    Keyboard Constants
//
//***************************************************************************

#ifndef _keyboard_private
#define _keyboard_private

#define KEYQMAX            256
#define KEYBOARDINT        0x09
#define NUMPAUSESCANCODES  6
#define EXTENDEDKEYSCANCODE 0xe0

/*
=============================================================================

                                    MACROS

=============================================================================
*/

#define KB_SetKeyDown( scan ) \
   { \
   KB_KeyDown[ ( scan ) ] = true; \
   }

#define IS_KEYPAD_CODE(scode)         \
           (                          \
              (                       \
                 ((scode) >= 0x47) && \
                 ((scode) <= 0x53)    \
              )  ||                   \
              (                       \
                 ((scode) >= 0x67) && \
                 ((scode) <= 0x68)    \
              )  ||                   \
              (                       \
                 ((scode) == 0x37)    \
              )                       \
           )
#endif
