// Text Mode Lib
#include <dos.h>
#include <conio.h>
#include <mem.h>
#include "types.h"
#include "develop.h"
#include "util_lib.h"
#include "_textlib.h"
#include "text_lib.h"


static int32 * textylookup;
static boolean TextModeStarted = false;
static uint8 * dosbackground;
int32 maxtextwidth;
int32 maxtextheight;

//******************************************************************************
//
// StartTextMode ()
//
//******************************************************************************

void StartTextMode (void)
   {
   int32 i;

#ifdef __FLAT__
   maxtextwidth = (int32) *( (word *) 0x44a );
   maxtextheight = (int32) *( (byte *) 0x484 ) + 1;
#else
   maxtextwidth = (int32) *( (word far *) MK_FP(0x40,0x4a) );
   maxtextheight = (int32) *( (byte far *) MK_FP(0x40,0x84) ) + 1;
#endif

   if (TextModeStarted == true)
      return;

   TextModeStarted = true;

   textylookup = SafeMalloc (maxtextheight * sizeof(int32));
   for (i=0; i<maxtextheight; i++)
      {
      textylookup[i] = i*maxtextwidth*2;
      }

   dosbackground = SafeMalloc(maxtextheight * maxtextwidth * 2);
   SaveTextBackground (0, 0, maxtextwidth, maxtextheight, dosbackground);

   TurnOffTextCursor ();
   ToggleBlinking ();

   }

//******************************************************************************
//
// ShutdownTextMode ()
//
//******************************************************************************

void ShutdownTextMode (void)
   {
   if (TextModeStarted == false)
      return;

   TextModeStarted = false;

   TurnOnTextCursor ();

   RestoreTextBackground (0, 0, maxtextwidth, maxtextheight, dosbackground);

   SafeFree(textylookup);
   }


//******************************************************************************
//
// TurnOffTextCursor ()
//
//******************************************************************************

void TurnOffTextCursor ( void )
   {
   union REGS regs;

   regs.w.ax = 0x0100;
   regs.w.cx = 0x2000;
#ifdef __FLAT__
	int386(0x10,&regs,&regs);
#else
	int86(0x10,&regs,&regs);
#endif
   }

//******************************************************************************
//
// TurnOnTextCursor ()
//
//******************************************************************************

void TurnOnTextCursor ( void )
   {
   union REGS regs;

   regs.w.ax = 0x0100;
   regs.w.cx = 0x0708;
#ifdef __FLAT__
	int386(0x10,&regs,&regs);
#else
	int86(0x10,&regs,&regs);
#endif
   }

//******************************************************************************
//
// ToggleBlinking ()
//
//******************************************************************************

void ToggleBlinking ( void )
   {
   union REGS regs;

   regs.w.bx = 0;
   regs.w.ax = 0x1003;
#ifdef __FLAT__
	int386(0x10,&regs,&regs);
#else
	int86(0x10,&regs,&regs);
#endif
   }

//******************************************************************************
//
// LimitXY ()
//
//******************************************************************************

void LimitXY
   (
   int32 * x,
   int32 * y
   )

   {
   if ( *x < 0 )
      {
      *x = 0;
      }
   if ( *x >= maxtextwidth )
      {
      *x = maxtextwidth;
      }

   if ( *y < 0 )
      {
      *y = 0;
      }
   if ( *y >= maxtextheight )
      {
      *y = maxtextheight;
      }
   }


//******************************************************************************
//
// TextFrame ()
//
//******************************************************************************

void TextFrame
   (
   int32 x1,
   int32 y1,
   int32 x2,
   int32 y2,
   int32 type,
   int32 foreground,
   int32 background
   )

   {
   int32 x;
   int32 y;

   LimitXY(&x1, &y1);
   LimitXY(&x2, &y2);

   if ( type == NO_FRAME )
      {
      for( x = x1 + 1; x < x2; x++ )
         {
         Plot( x, y1, type, foreground, background );
         Plot( x, y2, type, foreground, background );
         }
      for( y = y1 + 1; y < y2; y++ )
         {
         Plot( x1, y, type, foreground, background );
         Plot( x2, y, type, foreground, background );
         }
      }
   else if ( type == SINGLE_FRAME )
      {
      Plot( x1, y1, '', foreground, background );
      Plot( x2, y1, '', foreground, background );
      Plot( x1, y2, '', foreground, background );
      Plot( x2, y2, '', foreground, background );
      for( x = x1 + 1; x < x2; x++ )
         {
         Plot( x, y1, '', foreground, background );
         Plot( x, y2, '', foreground, background );
         }
      for( y = y1 + 1; y < y2; y++ )
         {
         Plot( x1, y, '', foreground, background );
         Plot( x2, y, '', foreground, background );
         }
      }
   else if ( type == DOUBLE_FRAME )
      {
      Plot( x1, y1, '', foreground, background );
      Plot( x2, y1, '', foreground, background );
      Plot( x1, y2, '', foreground, background );
      Plot( x2, y2, '', foreground, background );
      for( x = x1 + 1; x < x2; x++ )
         {
         Plot( x, y1, '', foreground, background );
         Plot( x, y2, '', foreground, background );
         }
      for( y = y1 + 1; y < y2; y++ )
         {
         Plot( x1, y, '', foreground, background );
         Plot( x2, y, '', foreground, background );
         }
      }
   }

//******************************************************************************
//
// TextBox ()
//
//******************************************************************************

void TextBox
   (
   int32  x1,
   int32  y1,
   int32  x2,
   int32  y2,
   int32  ch,
   int32  foreground,
   int32  background
   )

   {
   int x;
   int y;

   LimitXY(&x1, &y1);
   LimitXY(&x2, &y2);

   for( x = x1; x <= x2; x++ )
      {
      for( y = y1; y <= y2; y++ )
         {
         Plot( x, y, ch, foreground, background );
         }
      }
   }

//******************************************************************************
//
// AttributeBox ()
//
//******************************************************************************

void AttributeBox
   (
   int32  x1,
   int32  y1,
   int32  x2,
   int32  y2,
   int32  foreground,
   int32  background
   )

   {
   int x;
   int y;

   LimitXY(&x1, &y1);
   LimitXY(&x2, &y2);

   for( x = x1; x <= x2; x++ )
      {
      for( y = y1; y <= y2; y++ )
         {
         PlotAttribute( x, y, (( (background&0xf) << 4 ) + (foreground&0xf)) );
         }
      }
   }

//******************************************************************************
//
// SaveTextBackground ()
//
//******************************************************************************

void SaveTextBackground ( int32 x, int32 y, int32 w, int32 h, byte * buffer )
   {
   int32 j;

   for (j=0; j<h; j++)
      {
      memcpy( buffer + ( j * (w << 1) ), TextAddress(x,y+j), w << 1);
      }
   }

//******************************************************************************
//
// RestoreTextBackground ()
//
//******************************************************************************

void RestoreTextBackground ( int32 x, int32 y, int32 w, int32 h, byte * buffer )
   {
   int32 j;

   for (j=0; j<h; j++)
      {
      memcpy( TextAddress(x,y+j), buffer + ( j * (w << 1) ), w << 1);
      }
   }

//******************************************************************************
//
// DrawCharacter ()
//
//******************************************************************************

void DrawCharacter
   (
   int32  x,
   int32  y,
   int32  ch,
   int32  foreground,
   int32  background
   )

   {
   LimitXY(&x, &y);

   Plot(x,y,ch,foreground,background);
   }

//******************************************************************************
//
// DrawString ()
//
//******************************************************************************

int32 DrawString
   (
   int32 x,
   int32 y,
   char * string,
   int32 foreground,
   int32 background
   )
   {
   int32 count;
   char *ptr;

   ptr = string;
   count = 0;

   while ( *ptr )
      {
      DrawCharacter
         (
         count+x,
         y,
         *ptr,
         foreground,
         background
         );
      count++;
      ptr++;
      }

   return( count );
   }

/*
===================
=
= DrawBlankLine
=
===================
*/

void DrawBlankLine( int32 x, int32 y, int32 w, int32 foreground, int32 background )
   {
   TextBox
      (
      x,
      y,
      x+w,
      y,
      ' ',
      foreground,
      background
      );
   }

//******************************************************************************
//
// GetCharacter ()
//
//******************************************************************************

void GetCharacter
   (
   int32  x,
   int32  y,
   int32 * ch,
   int32 * foreground,
   int32 * background
   )

   {
   LimitXY(&x, &y);
   *ch = *(byte *)TextAddress(x,y);
   *foreground = *(byte *)(TextAddress(x,y)+1);
   *background = (*foreground) >> 4;
   *foreground &= 0xf;
   }

//******************************************************************************
//
// BlockSize ()
//
//******************************************************************************

void BlockSize
   (
   char * block,
   int32 * width,
   int32 * height
   )
   {
   boolean more;
   int32 length;

   *width = 0;
   *height = 0;

   if (block == NULL)
      {
      return;
      }

   more = true;

   while (more == true)
      {
      more = NextStringInBlock( block, &length );
      if ( length > (*width) )
         {
         (*width) = length;
         }
      (*height)++;
      if (more == true)
         {
         block += (length+1);
         }
      }
   }

//******************************************************************************
//
// NextStringInBlock ()
//
//******************************************************************************

boolean NextStringInBlock
   (
   char * block,
   int32 * length
   )
   {
   if (block == NULL)
      return false;

   (*length) = 0;
   while ((*(block+(*length)) != '\n') && (*(block+(*length)) != '\0'))
      {
      (*length)++;
      }
   if (*(block + (*length)) == '\0')
      {
      return false;
      }
   else
      {
      return true;
      }
   }

