#include <conio.h>
#include <io.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "types.h"
#include "develop.h"
#include "file_lib.h"
#include "util_lib.h"
#include "keyboard.h"
#include "scriplib.h"
#include "tokenlib.h"
#include "linklist.h"
#include "common.h"
#include "gamedefs.h"

int32 NumGameFunctions;
int32 writehandle;

/*
===================
=
= WriteString
=
===================
*/
void WriteString ( char * string )
   {
   int32 length;

   length = strlen(string);
   SafeWrite(writehandle,string,length);
   }


/*
===================
=
= WriteHeader
=
===================
*/
void WriteHeader( void )
   {
   WriteString("// file created by makehead.exe\n");
   WriteString("// this header contains default key assignments, as well as\n");
   WriteString("// default button assignments and game function names\n\n\n");
   }

/*
===================
=
= WriteEnums
=
===================
*/
void WriteEnums( void )
   {
   char str[80];
   int32 entry;
   int32 handle;

   WriteString("\n#define NUMGAMEFUNCTIONS ");
   sprintf(str,"%ld\n\n",NumGameFunctions);
   WriteString(str);

   WriteString("extern char * gamefunctions[];\n\n");
   if (SafeFileExists("function.ini"))
      {
      handle = TOKEN_Load("function.ini");
      WriteString("typedef enum\n");
      WriteString("   {\n");
      for (entry=0;entry<NumGameFunctions;entry++)
         {
         int32 len;

         TOKEN_GetLine(handle,true);
         WriteString("   gamefunc_");
         len = strlen(token)-1;
         while (token[len]<32)
            token[len--]=0;
         WriteString(token);
         WriteString(",\n");
         }
      WriteString("   };\n");
      TOKEN_Free(handle);
      }
   else
      {
      Error("function.ini not found\n");
      }
   }

/*
===================
=
= StoreDefaultKeyDefinitions
=
===================
*/
void StoreDefaultKeyDefinitions( void )
   {
   int32 numkeyentries;
   int32 i;
   int32 handle;
   char * functionname;
   char str[80];
   char keyname1[80];
   char keyname2[80];

   if (SafeFileExists("default.ini"))
      {
      handle = SCRIPT_Load ( "default.ini" );
      numkeyentries = SCRIPT_NumberEntries( handle, "DefaultDefinitions" );

      WriteString("\n#define NUMKEYENTRIES ");
      sprintf(str,"%ld\n\n",numkeyentries);
      WriteString(str);
      WriteString("static char * keydefaults[] =\n");
      WriteString("   {\n");
      for (i=0;i<numkeyentries;i++)
         {
         functionname = SCRIPT_Entry( handle, "DefaultDefinitions", i );
         memset(keyname1,0,sizeof(keyname1));
         memset(keyname2,0,sizeof(keyname2));
         SCRIPT_GetDoubleString( handle, "DefaultDefinitions", functionname, keyname1, keyname2);
         WriteString("   \"");
         WriteString(functionname);
         WriteString("\", ");
         WriteString("\"");
         WriteString(keyname1);
         WriteString("\", ");
         WriteString("\"");
         WriteString(keyname2);
         WriteString("\", \n");
         }
      WriteString("   };\n");
      SCRIPT_Free(handle);
      }
   else
      {
      Error("default.ini not found");
      }
   }

/*
===================
=
= StoreButtonDefaults
=
===================
*/
void StoreButtonDefaults( void )
   {
   int32 i;
   char functionname[80];
   char str[80];
   int32 handle;

   if (SafeFileExists("default.ini"))
      {
      handle = SCRIPT_Load ( "default.ini" );
      WriteString("\n\nstatic char * mousedefaults[] =\n");
      WriteString("   {\n");
      for (i=0;i<MAXMOUSEBUTTONS;i++)
         {
         sprintf(str,"MouseButton%ld",i);
         SCRIPT_GetString( handle,"DefaultButtons", str,functionname);
         WriteString("   \"");
         WriteString(functionname);
         WriteString("\",\n");
         }
      WriteString("   };\n");
      WriteString("\n\nstatic char * mouseclickeddefaults[] =\n");
      WriteString("   {\n");
      for (i=0;i<MAXMOUSEBUTTONS;i++)
         {
         sprintf(str,"MouseButtonClicked%ld",i);
         SCRIPT_GetString( handle, "DefaultButtons", str,functionname);
         WriteString("   \"");
         WriteString(functionname);
         WriteString("\",\n");
         }
      WriteString("   };\n");
      WriteString("\n\nstatic char * joystickdefaults[] =\n");
      WriteString("   {\n");
      for (i=0;i<MAXJOYBUTTONS;i++)
         {
         sprintf(str,"JoystickButton%ld",i);
         SCRIPT_GetString( handle, "DefaultButtons", str,functionname);
         WriteString("   \"");
         WriteString(functionname);
         WriteString("\",\n");
         }
      WriteString("   };\n");
      WriteString("\n\nstatic char * joystickclickeddefaults[] =\n");
      WriteString("   {\n");
      for (i=0;i<MAXJOYBUTTONS;i++)
         {
         sprintf(str,"JoystickButtonClicked%ld",i);
         SCRIPT_GetString( handle,"DefaultButtons", str,functionname);
         WriteString("   \"");
         WriteString(functionname);
         WriteString("\",\n");
         }
      WriteString("   };\n");
      SCRIPT_Free(handle);
      }
   else
      {
      Error("default.ini not found");
      }
   }

/*
===================
=
= StoreFunctions
=
===================
*/
void StoreFunctions( void )
   {
   int32 entry;
   int32 handle;

   if (SafeFileExists("function.ini"))
      {
      handle = TOKEN_Load ( "function.ini" );
      NumGameFunctions = TOKEN_LinesInFile(handle);
      WriteString("char * gamefunctions[] =\n");
      WriteString("   {\n");
      for (entry=0;entry<NumGameFunctions;entry++)
         {
         int32 len;

         TOKEN_GetLine(handle,true);
         len = strlen(token)-1;
         while (token[len]<32)
            token[len--]=0;
         WriteString("   \"");
         WriteString(token);
         WriteString("\",\n");
         }
      WriteString("   };\n");
      TOKEN_Free(handle);
      }
   else
      {
      Error("function.ini not found\n");
      }
   }


/*
===================
=
= Shutdown
=
===================
*/

void ShutDown( void )
   {
   }

void main( void )
   {
   writehandle=SafeOpenWrite("function.c",filetype_text);
   WriteString("// function.c\n\n");
   WriteHeader();
   StoreFunctions();
   StoreDefaultKeyDefinitions();
   StoreButtonDefaults();
   SafeClose(writehandle);

   writehandle=SafeOpenWrite("function.h",filetype_text);
   WriteString("// function.h\n\n");
   WriteHeader();
   WriteString("#ifndef _function_public_\n");
   WriteString("#define _function_public_\n");
   WriteEnums();
   WriteString("#endif\n");
   SafeClose(writehandle);
   }
