#ifndef _lumptype_public
#define _lumptype_public

#define MAXLUMP      0x40000 // biggest possible lump (256k)

typedef enum
   {
   lumptype_unknown,
   lumptype_pic,
   lumptype_lpic,
   lumptype_post,
   lumptype_post_raw,
   lumptype_raw,
   lumptype_patch255,
   lumptype_patch,
   lumptype_palette,
   lumptype_patch255_all,
   lumptype_patch_all,
   lumptype_mipmap,
   lumptype_font,
   lumptype_color_font,
   lumptype_intensity_font,
   lumptype_sound,
   lumptype_label,
   lumptype_colormap
   } lumptype_t;

typedef struct
   {
   int16 width,height;
   byte  data;
   } pic_t;

typedef struct
   {
   int16 width,height;
   int16 orgx,orgy;
   byte  data;
   } lpic_t;

typedef struct
   {
   int16 width,height;
   byte  data;
   } post_t;

typedef struct
   {
   byte  height;
   byte  width[256];
   int16 charofs[256];
   byte  data;       // as much as required
   } font_t;

typedef struct
   {
   byte  height;
   byte  width[256];
   int16 charofs[256];
   byte  pal[0x300];
   byte  data;       // as much as required
   } cfont_t;

typedef struct
   {
   byte  height;
   byte  width[256];
   int16 charofs[256];
   byte  numlevels;
   byte  data;       // as much as required
   } ifont_t;

typedef struct
   {
   byte origx;         // the orig width and height
   byte origy;
   byte width;            // bounding box size
   byte height;
   byte leftoffset;       // pixels to the left of origin
   byte topoffset;        // pixels above the origin
   int16 collumnofs[256]; // only [width] used, the [0] is &collumnofs[width]
   } patch_t;

typedef struct
   {
   byte width;
   byte height;
   byte numlevels;
   int16 mapofs[8];
   } mipmap_t;

typedef struct
   {
   boolean reverse;
   byte numlevels;
   byte numdark;
   byte data;
   } colormap_t;

#endif


